/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public interface EventLoopGroupFactory {
    public static final String NATIVE = "native";

    default public boolean isNative() {
        return false;
    }

    public EventLoopGroup createEventLoopGroup(int var1, Executor var2, @Nullable Integer var3);

    default public EventLoopGroup createEventLoopGroup(EventLoopGroupConfiguration configuration, ThreadFactory threadFactory) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        ArgumentUtils.requireNonNull((String)"threadFactory", (Object)threadFactory);
        return this.createEventLoopGroup(configuration.getNumThreads(), threadFactory, (Integer)configuration.getIoRatio().orElse(null));
    }

    public EventLoopGroup createEventLoopGroup(int var1, @Nullable ThreadFactory var2, @Nullable Integer var3);

    default public EventLoopGroup createEventLoopGroup(int threads, @Nullable Integer ioRatio) {
        return this.createEventLoopGroup(threads, (ThreadFactory)null, ioRatio);
    }

    @NonNull
    public Class<? extends ServerSocketChannel> serverSocketChannelClass();

    @NonNull
    default public Class<? extends ServerSocketChannel> serverSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return this.serverSocketChannelClass();
    }

    @NonNull
    default public ServerSocketChannel serverSocketChannelInstance(@Nullable EventLoopGroupConfiguration configuration) {
        try {
            return this.serverSocketChannelClass(configuration).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate server socket channel instance");
        }
    }

    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration var1);

    @NonNull
    default public SocketChannel clientSocketChannelInstance(@Nullable EventLoopGroupConfiguration configuration) {
        try {
            return this.clientSocketChannelClass(configuration).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate server socket channel instance");
        }
    }
}

