/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.NioEventLoopGroupFactory;
import io.micronaut.http.netty.configuration.NettyGlobalConfiguration;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.ResourceLeakDetector;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Primary
@Singleton
@BootstrapContextCompatible
public class DefaultEventLoopGroupFactory
implements EventLoopGroupFactory {
    private boolean useNativeTransport = false;
    private final EventLoopGroupFactory nativeFactory;
    private final EventLoopGroupFactory defaultFactory;

    public DefaultEventLoopGroupFactory(NioEventLoopGroupFactory nioEventLoopGroupFactory, @Nullable @Named(value="native") EventLoopGroupFactory nativeFactory) {
        this(nioEventLoopGroupFactory, nativeFactory, null);
    }

    @Inject
    public DefaultEventLoopGroupFactory(NioEventLoopGroupFactory nioEventLoopGroupFactory, @Nullable @Named(value="native") EventLoopGroupFactory nativeFactory, @Nullable NettyGlobalConfiguration nettyGlobalConfiguration) {
        this.defaultFactory = nioEventLoopGroupFactory;
        EventLoopGroupFactory eventLoopGroupFactory = this.nativeFactory = nativeFactory != null ? nativeFactory : this.defaultFactory;
        if (nettyGlobalConfiguration != null && nettyGlobalConfiguration.getResourceLeakDetectorLevel() != null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)nettyGlobalConfiguration.getResourceLeakDetectorLevel());
        }
    }

    @Deprecated
    @Inject
    protected void setUseNativeTransport(@Property(name="micronaut.server.netty.use-native-transport") @Nullable Boolean useNativeTransport) {
        if (useNativeTransport != null) {
            this.useNativeTransport = useNativeTransport;
        }
    }

    @Override
    public EventLoopGroup createEventLoopGroup(EventLoopGroupConfiguration configuration, ThreadFactory threadFactory) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        ArgumentUtils.requireNonNull((String)"threadFactory", (Object)threadFactory);
        if (this.useNativeTransport || configuration.isPreferNativeTransport()) {
            return this.nativeFactory.createEventLoopGroup(configuration, threadFactory);
        }
        return this.defaultFactory.createEventLoopGroup(configuration, threadFactory);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return this.nativeFactory.createEventLoopGroup(threads, executor, ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, @Nullable ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return this.nativeFactory.createEventLoopGroup(threads, threadFactory, ioRatio);
    }

    @Override
    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return this.nativeFactory.serverSocketChannelClass();
    }

    @Override
    @NonNull
    public Class<? extends ServerSocketChannel> serverSocketChannelClass(EventLoopGroupConfiguration configuration) {
        if (this.useNativeTransport || configuration != null && configuration.isPreferNativeTransport()) {
            return this.nativeFactory.serverSocketChannelClass(configuration);
        }
        return this.defaultFactory.serverSocketChannelClass(configuration);
    }

    @Override
    public ServerSocketChannel serverSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        if (this.useNativeTransport || configuration != null && configuration.isPreferNativeTransport()) {
            return this.nativeFactory.serverSocketChannelInstance(configuration);
        }
        return this.defaultFactory.serverSocketChannelInstance(configuration);
    }

    @Override
    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        if (this.useNativeTransport || configuration != null && configuration.isPreferNativeTransport()) {
            return this.nativeFactory.clientSocketChannelClass(configuration);
        }
        return this.defaultFactory.clientSocketChannelClass(configuration);
    }

    @Override
    @NonNull
    public SocketChannel clientSocketChannelInstance(@Nullable EventLoopGroupConfiguration configuration) {
        if (this.useNativeTransport || configuration != null && configuration.isPreferNativeTransport()) {
            return this.nativeFactory.clientSocketChannelInstance(configuration);
        }
        return this.defaultFactory.clientSocketChannelInstance(configuration);
    }
}

