/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public interface EventLoopGroupFactory {
    public static final String NATIVE = "native";

    default public boolean isNative() {
        return false;
    }

    public EventLoopGroup createEventLoopGroup(int var1, Executor var2, @Nullable Integer var3);

    default public EventLoopGroup createEventLoopGroup(EventLoopGroupConfiguration configuration, ThreadFactory threadFactory) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        ArgumentUtils.requireNonNull((String)"threadFactory", (Object)threadFactory);
        return this.createEventLoopGroup(configuration.getNumThreads(), threadFactory, (Integer)configuration.getIoRatio().orElse(null));
    }

    public EventLoopGroup createEventLoopGroup(int var1, @Nullable ThreadFactory var2, @Nullable Integer var3);

    @Deprecated
    default public EventLoopGroup createEventLoopGroup(int threads, @Nullable Integer ioRatio) {
        return this.createEventLoopGroup(threads, (ThreadFactory)null, ioRatio);
    }

    @Deprecated
    default public EventLoopGroup createEventLoopGroup(@Nullable Integer ioRatio) {
        return this.createEventLoopGroup(0, (ThreadFactory)null, ioRatio);
    }

    @NonNull
    public Class<? extends ServerSocketChannel> serverSocketChannelClass();

    @NonNull
    default public Class<? extends ServerSocketChannel> serverSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return this.serverSocketChannelClass();
    }

    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration var1);
}

