/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.netty.channel.DefaultEventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.EventLoopGroupRegistry;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.inject.Named;
import javax.inject.Singleton;

@Factory
@Internal
@BootstrapContextCompatible
public class DefaultEventLoopGroupRegistry
implements EventLoopGroupRegistry {
    private final EventLoopGroupFactory eventLoopGroupFactory;
    private final BeanLocator beanLocator;

    public DefaultEventLoopGroupRegistry(EventLoopGroupFactory eventLoopGroupFactory, BeanLocator beanLocator) {
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.beanLocator = beanLocator;
    }

    @EachBean(value=EventLoopGroupConfiguration.class)
    @Bean(preDestroy="shutdownGracefully")
    @BootstrapContextCompatible
    protected EventLoopGroup eventLoopGroup(EventLoopGroupConfiguration configuration) {
        String executor = configuration.getExecutorName().orElse(null);
        if (executor != null) {
            return this.beanLocator.findBean(Executor.class, Qualifiers.byName((String)executor)).map(executorService -> this.eventLoopGroupFactory.createEventLoopGroup(configuration.getNumThreads(), (Executor)executorService, (Integer)configuration.getIoRatio().orElse(null))).orElseThrow(() -> new ConfigurationException("No executor service configured for name: " + executor));
        }
        ThreadFactory threadFactory = this.beanLocator.findBean(ThreadFactory.class, Qualifiers.byName((String)configuration.getName())).orElseGet(() -> new DefaultThreadFactory(configuration.getName() + "-" + DefaultThreadFactory.toPoolName(NioEventLoopGroup.class)));
        return this.eventLoopGroupFactory.createEventLoopGroup(configuration, threadFactory);
    }

    @Singleton
    @Requires(missingProperty="micronaut.netty.event-loops.default")
    @Primary
    @Bean(preDestroy="shutdownGracefully")
    @BootstrapContextCompatible
    protected EventLoopGroup defaultEventLoopGroup(@Named(value="netty") ThreadFactory threadFactory) {
        return this.eventLoopGroupFactory.createEventLoopGroup(new DefaultEventLoopGroupConfiguration(), threadFactory);
    }

    @Override
    @NonNull
    public EventLoopGroup getDefaultEventLoopGroup() {
        return (EventLoopGroup)this.beanLocator.getBean(EventLoopGroup.class);
    }

    @Override
    public Optional<EventLoopGroup> getEventLoopGroup(@NonNull String name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        if ("default".equals(name)) {
            return this.beanLocator.findBean(EventLoopGroup.class);
        }
        return this.beanLocator.findBean(EventLoopGroup.class, Qualifiers.byName((String)name));
    }

    @Override
    public Optional<EventLoopGroupConfiguration> getEventLoopGroupConfiguration(@NonNull String name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        return this.beanLocator.findBean(EventLoopGroupConfiguration.class, Qualifiers.byName((String)name));
    }
}

