/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import java.util.Optional;

@EachProperty(value="micronaut.netty.event-loops", primary="default")
public class DefaultEventLoopGroupConfiguration
implements EventLoopGroupConfiguration {
    private final int numThreads;
    private final Integer ioRatio;
    private final boolean preferNativeTransport;
    private final String name;
    private final String executor;

    @ConfigurationInject
    public DefaultEventLoopGroupConfiguration(@Parameter String name, @Bindable(defaultValue="0") int numThreads, @Nullable Integer ioRatio, @Bindable(defaultValue="false") boolean preferNativeTransport, @Nullable String executor) {
        this.name = name;
        this.numThreads = numThreads;
        this.ioRatio = ioRatio;
        this.preferNativeTransport = preferNativeTransport;
        this.executor = executor;
    }

    public DefaultEventLoopGroupConfiguration() {
        this.name = "default";
        this.numThreads = 0;
        this.ioRatio = null;
        this.preferNativeTransport = false;
        this.executor = null;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public Optional<Integer> getIoRatio() {
        return Optional.ofNullable(this.ioRatio);
    }

    @Override
    public Optional<String> getExecutorName() {
        return Optional.ofNullable(this.executor);
    }

    @Override
    public boolean isPreferNativeTransport() {
        return this.preferNativeTransport;
    }

    @NonNull
    public String getName() {
        return this.name;
    }
}

