/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.TypeHint;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.concurrent.ThreadFactory;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Factory
@TypeHint(value={NioServerSocketChannel.class, NioSocketChannel.class}, typeNames={"sun.security.ssl.SSLContextImpl$TLSContext"}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS})
@BootstrapContextCompatible
public class NettyThreadFactory {
    public static final String NAME = "netty";
    public static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));

    @Singleton
    @Named(value="netty")
    @BootstrapContextCompatible
    protected ThreadFactory nettyThreadFactory() {
        return new DefaultThreadFactory(NioEventLoopGroup.class);
    }
}

