/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.netty.NettyHttpParameters;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.DefaultAttributeMap;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Optional;

@Internal
public abstract class AbstractNettyHttpRequest<B>
extends DefaultAttributeMap
implements HttpRequest<B> {
    protected final io.netty.handler.codec.http.HttpRequest nettyRequest;
    protected final ConversionService<?> conversionService;
    protected final HttpMethod httpMethod;
    protected final URI uri;
    private NettyHttpParameters httpParameters;
    private MediaType mediaType;
    private Charset charset;
    private Locale locale;
    private String path;

    public AbstractNettyHttpRequest(io.netty.handler.codec.http.HttpRequest nettyRequest, ConversionService conversionService) {
        this.nettyRequest = nettyRequest;
        this.conversionService = conversionService;
        String fullUri = nettyRequest.uri();
        this.uri = URI.create(fullUri);
        this.httpMethod = HttpMethod.valueOf((String)nettyRequest.method().name());
    }

    public io.netty.handler.codec.http.HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpParameters getParameters() {
        NettyHttpParameters httpParameters = this.httpParameters;
        if (httpParameters == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                httpParameters = this.httpParameters;
                if (httpParameters == null) {
                    this.httpParameters = httpParameters = this.decodeParameters(this.nettyRequest.uri());
                }
            }
        }
        return httpParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<MediaType> getContentType() {
        MediaType contentType = this.mediaType;
        if (contentType == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                contentType = this.mediaType;
                if (contentType == null) {
                    this.mediaType = contentType = (MediaType)super.getContentType().orElse(null);
                }
            }
        }
        return Optional.ofNullable(contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset getCharacterEncoding() {
        Charset charset = this.charset;
        if (charset == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                charset = this.charset;
                if (charset == null) {
                    this.charset = charset = this.initCharset(super.getCharacterEncoding());
                }
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Locale> getLocale() {
        Locale locale = this.locale;
        if (locale == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                locale = this.locale;
                if (locale == null) {
                    this.locale = locale = (Locale)super.getLocale().orElse(null);
                }
            }
        }
        return Optional.ofNullable(locale);
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        String path = this.path;
        if (path == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                path = this.path;
                if (path == null) {
                    this.path = path = this.decodePath(this.nettyRequest.uri());
                }
            }
        }
        return path;
    }

    protected abstract Charset initCharset(Charset var1);

    protected QueryStringDecoder createDecoder(String uri) {
        Charset charset = this.getCharacterEncoding();
        return charset != null ? new QueryStringDecoder(uri, charset) : new QueryStringDecoder(uri);
    }

    private String decodePath(String uri) {
        QueryStringDecoder queryStringDecoder = this.createDecoder(uri);
        return queryStringDecoder.rawPath();
    }

    private NettyHttpParameters decodeParameters(String uri) {
        QueryStringDecoder queryStringDecoder = this.createDecoder(uri);
        return new NettyHttpParameters(queryStringDecoder.parameters(), this.conversionService);
    }
}

