/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.ConvertibleMultiValuesMap;
import io.micronaut.http.MutableHttpParameters;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
public class NettyHttpParameters
implements MutableHttpParameters {
    private final LinkedHashMap<CharSequence, List<String>> valuesMap;
    private final ConvertibleMultiValues<String> values;

    public NettyHttpParameters(Map<String, List<String>> parameters, ConversionService conversionService) {
        this.valuesMap = new LinkedHashMap(parameters.size());
        this.values = new ConvertibleMultiValuesMap(this.valuesMap, conversionService);
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            this.valuesMap.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
    }

    public Set<String> names() {
        return this.values.names();
    }

    public Collection<List<String>> values() {
        return this.values.values();
    }

    public List<String> getAll(CharSequence name) {
        return this.values.getAll(name);
    }

    public String get(CharSequence name) {
        return (String)this.values.get(name);
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.values.get(name, conversionContext);
    }

    public MutableHttpParameters add(CharSequence name, List<CharSequence> values) {
        this.valuesMap.put(name, Collections.unmodifiableList(values.stream().map(v -> v == null ? null : v.toString()).collect(Collectors.toList())));
        return this;
    }
}

