/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function;

import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.FunctionBean;
import io.micronaut.function.LocalFunctionRegistry;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultLocalFunctionRegistry
implements ExecutableMethodProcessor<FunctionBean>,
LocalFunctionRegistry,
MediaTypeCodecRegistry {
    private final Map<String, ExecutableMethod<?, ?>> consumers = new LinkedHashMap(1);
    private final Map<String, ExecutableMethod<?, ?>> functions = new LinkedHashMap(1);
    private final Map<String, ExecutableMethod<?, ?>> biFunctions = new LinkedHashMap(1);
    private final Map<String, ExecutableMethod<?, ?>> suppliers = new LinkedHashMap(1);
    private final MediaTypeCodecRegistry decoderRegistry;

    public DefaultLocalFunctionRegistry(MediaTypeCodec ... decoders) {
        this.decoderRegistry = MediaTypeCodecRegistry.of((MediaTypeCodec[])decoders);
    }

    @Inject
    public DefaultLocalFunctionRegistry(List<MediaTypeCodec> decoders) {
        this.decoderRegistry = MediaTypeCodecRegistry.of(decoders);
    }

    public DefaultLocalFunctionRegistry(MediaTypeCodecRegistry codecRegistry) {
        this.decoderRegistry = codecRegistry;
    }

    public Optional<? extends ExecutableMethod<?, ?>> findFirst() {
        return Stream.of(this.functions, this.suppliers, this.consumers, this.biFunctions).map(all -> {
            Collection values = all.values();
            return values.stream().findFirst();
        }).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<? extends ExecutableMethod<?, ?>> find(String name) {
        return Stream.of(this.functions, this.suppliers, this.consumers, this.biFunctions).flatMap(map -> {
            ExecutableMethod method = (ExecutableMethod)map.get(name);
            if (method == null) {
                return Stream.empty();
            }
            return Stream.of(method);
        }).findFirst();
    }

    @Override
    public Map<String, URI> getAvailableFunctions() {
        return Collections.emptyMap();
    }

    @Override
    public <T> Optional<ExecutableMethod<Supplier<T>, T>> findSupplier(String name) {
        ExecutableMethod<?, ?> method = this.suppliers.get(name);
        if (method != null) {
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<ExecutableMethod<Consumer<T>, Void>> findConsumer(String name) {
        ExecutableMethod<?, ?> method = this.consumers.get(name);
        if (method != null) {
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Override
    public <T, R> Optional<ExecutableMethod<Function<T, R>, R>> findFunction(String name) {
        ExecutableMethod<?, ?> method = this.functions.get(name);
        if (method != null) {
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Override
    public <T, U, R> Optional<ExecutableMethod<BiFunction<T, U, R>, R>> findBiFunction(String name) {
        ExecutableMethod<?, ?> method = this.biFunctions.get(name);
        if (method != null) {
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        if (method.hasAnnotation(FunctionBean.class)) {
            String functionId = method.stringValue(FunctionBean.class).orElse(null);
            Class declaringType = method.getDeclaringType();
            if (StringUtils.isEmpty((CharSequence)functionId)) {
                String typeName = declaringType.getSimpleName();
                functionId = typeName.contains("$") ? NameUtils.hyphenate((String)method.getMethodName()) : NameUtils.hyphenate((String)typeName);
            }
            if (Function.class.isAssignableFrom(declaringType) && method.getMethodName().equals("apply")) {
                this.registerFunction(method, functionId);
            } else if (Consumer.class.isAssignableFrom(declaringType) && method.getMethodName().equals("accept")) {
                this.registerConsumer(method, functionId);
            } else if (BiFunction.class.isAssignableFrom(declaringType) && method.getMethodName().equals("apply")) {
                this.registerBiFunction(method, functionId);
            } else if (Supplier.class.isAssignableFrom(declaringType) && method.getMethodName().equals("get")) {
                this.registerSupplier(method, functionId);
            }
        }
    }

    public Optional<MediaTypeCodec> findCodec(MediaType mediaType) {
        return this.decoderRegistry.findCodec(mediaType);
    }

    public Optional<MediaTypeCodec> findCodec(MediaType mediaType, Class<?> type) {
        return this.decoderRegistry.findCodec(mediaType, type);
    }

    public Collection<MediaTypeCodec> getCodecs() {
        return this.decoderRegistry.getCodecs();
    }

    private void registerSupplier(ExecutableMethod<?, ?> method, String functionId) {
        this.suppliers.put(functionId, method);
    }

    private void registerBiFunction(ExecutableMethod<?, ?> method, String functionId) {
        this.biFunctions.put(functionId, method);
    }

    private void registerConsumer(ExecutableMethod<?, ?> method, String functionId) {
        this.consumers.put(functionId, method);
    }

    private void registerFunction(ExecutableMethod<?, ?> method, String functionId) {
        this.functions.put(functionId, method);
    }
}

