/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.executor;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.env.Environment;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.io.Writable;
import io.micronaut.core.reflect.ClassLoadingReporter;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.exception.InvocationException;
import io.micronaut.core.type.Argument;
import io.micronaut.function.LocalFunctionRegistry;
import io.micronaut.function.executor.AbstractExecutor;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;

public class StreamFunctionExecutor<C>
extends AbstractExecutor<C> {
    public void execute(InputStream input, OutputStream output) throws IOException {
        this.execute(input, output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(InputStream input, OutputStream output, C context) throws IOException {
        Environment env;
        String functionName;
        ApplicationContext applicationContext = this.buildApplicationContext(context);
        if (context == null) {
            context = applicationContext;
        }
        if ((functionName = this.resolveFunctionName(env = this.startEnvironment(applicationContext))) == null) {
            throw new InvocationException("No Function name configured. Set 'micronaut.function.name' in your Function configuration");
        }
        LocalFunctionRegistry localFunctionRegistry = (LocalFunctionRegistry)applicationContext.getBean(LocalFunctionRegistry.class);
        ExecutableMethod<Object, Object> method = this.resolveFunction(localFunctionRegistry, functionName);
        Class returnJavaType = method.getReturnType().getType();
        if (ClassLoadingReporter.isReportingEnabled()) {
            ClassLoadingReporter.reportBeanPresent((Class)returnJavaType);
        }
        Argument[] requiredArguments = method.getArguments();
        int argCount = requiredArguments.length;
        Qualifier qualifier = Qualifiers.byName((String)functionName);
        Class functionType = method.getDeclaringType();
        BeanDefinition beanDefinition = applicationContext.getBeanDefinition(functionType, qualifier);
        Object bean = applicationContext.getBean(functionType, qualifier);
        List typeArguments = beanDefinition.getTypeArguments();
        try {
            Object result;
            switch (argCount) {
                case 0: {
                    result = method.invoke(bean, new Object[0]);
                    break;
                }
                case 1: {
                    Argument arg = requiredArguments[0];
                    if (!typeArguments.isEmpty()) {
                        arg = Argument.of((Class)((Argument)typeArguments.get(0)).getType(), (String)arg.getName());
                    }
                    Object value = this.decodeInputArgument((ConversionService<?>)env, localFunctionRegistry, (Argument<?>)arg, input);
                    result = method.invoke(bean, new Object[]{value});
                    break;
                }
                case 2: {
                    Argument firstArgument = requiredArguments[0];
                    Argument secondArgument = requiredArguments[1];
                    if (!typeArguments.isEmpty()) {
                        firstArgument = Argument.of((Class)((Argument)typeArguments.get(0)).getType(), (String)firstArgument.getName());
                    }
                    Object first = this.decodeInputArgument((ConversionService<?>)env, localFunctionRegistry, (Argument<?>)firstArgument, input);
                    Object second = this.decodeContext((ConversionService<?>)env, (Argument<?>)secondArgument, context);
                    result = method.invoke(bean, new Object[]{first, second});
                    break;
                }
                default: {
                    throw new InvocationException("Function [" + functionName + "] cannot be made executable.");
                }
            }
            if (result != null) {
                StreamFunctionExecutor.encode(env, localFunctionRegistry, returnJavaType, result, output);
            }
        }
        finally {
            this.closeApplicationContext();
        }
    }

    protected void closeApplicationContext() {
        try {
            this.applicationContext.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void encode(Environment environment, LocalFunctionRegistry registry, Class returnType, Object result, OutputStream output) throws IOException {
        if (ClassUtils.isJavaLangType((Class)returnType)) {
            if (result instanceof Byte) {
                output.write(((Byte)result).byteValue());
            } else if (result instanceof Boolean) {
                output.write((Boolean)result != false ? 1 : 0);
            } else if (result instanceof byte[]) {
                output.write((byte[])result);
            } else {
                byte[] bytes = (byte[])environment.convert((Object)result.toString(), byte[].class).orElseThrow(() -> new InvocationException("Unable to convert result [" + result + "] for output stream"));
                output.write(bytes);
            }
        } else if (result instanceof Writable) {
            Writable writable = (Writable)result;
            writable.writeTo(output, (Charset)environment.getProperty("micronaut.function.charset", Charset.class, (Object)StandardCharsets.UTF_8));
        } else {
            Optional codec;
            Optional optional = codec = registry instanceof MediaTypeCodecRegistry ? ((MediaTypeCodecRegistry)registry).findCodec(MediaType.APPLICATION_JSON_TYPE) : Optional.empty();
            if (codec.isPresent()) {
                ((MediaTypeCodec)codec.get()).encode(result, output);
            } else {
                byte[] bytes = (byte[])environment.convert(result, byte[].class).orElseThrow(() -> new InvocationException("Unable to convert result [" + result + "] for output stream"));
                output.write(bytes);
            }
        }
    }

    private Object decodeInputArgument(ConversionService<?> conversionService, LocalFunctionRegistry localFunctionRegistry, Argument<?> arg, InputStream input) {
        Class argType = arg.getType();
        ClassLoadingReporter.reportBeanPresent((Class)argType);
        if (ClassUtils.isJavaLangType((Class)argType)) {
            Object converted = this.doConvertInput(conversionService, arg, input);
            if (converted != null) {
                return converted;
            }
        } else {
            Optional registeredDecoder;
            if (argType.isInstance(input)) {
                return input;
            }
            if (localFunctionRegistry instanceof MediaTypeCodecRegistry && (registeredDecoder = ((MediaTypeCodecRegistry)localFunctionRegistry).findCodec(MediaType.APPLICATION_JSON_TYPE)).isPresent()) {
                MediaTypeCodec decoder = (MediaTypeCodec)registeredDecoder.get();
                return decoder.decode(arg, input);
            }
        }
        throw new CodecException("Unable to decode argument from stream: " + arg);
    }

    private Object decodeContext(ConversionService<?> conversionService, Argument<?> arg, Object context) {
        Object convert;
        if (ClassUtils.isJavaLangType((Class)arg.getType()) && (convert = this.doConvertInput(conversionService, arg, context)) != null) {
            return convert;
        }
        throw new CodecException("Unable to decode argument from stream: " + arg);
    }

    private Object doConvertInput(ConversionService<?> conversionService, Argument<?> arg, Object object) {
        ArgumentConversionContext conversionContext = ConversionContext.of(arg);
        Optional convert = conversionService.convert(object, conversionContext);
        if (convert.isPresent()) {
            return convert.get();
        }
        Optional lastError = conversionContext.getLastError();
        if (lastError.isPresent()) {
            throw new ConversionErrorException(arg, (ConversionError)lastError.get());
        }
        return null;
    }
}

