/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.visitor.async;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

@Internal
public final class AsyncTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    private static final String ANN = "io.micronaut.scheduling.annotation.Async";

    @Override
    public Set<String> getSupportedAnnotationNames() {
        return Set.of(ANN);
    }

    @Override
    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitMethod(MethodElement element, VisitorContext context) {
        if (!element.hasDeclaredAnnotation(ANN)) return;
        ClassElement returnType = element.getReturnType();
        if (returnType != null) {
            if (returnType.isAssignable(CompletionStage.class)) return;
            if (returnType.isAssignable(Void.TYPE)) return;
            if (returnType.isAssignable(Publisher.class)) return;
            if (Publishers.getKnownReactiveTypes().stream().anyMatch(returnType::isAssignable)) {
                return;
            }
        }
        boolean bl = false;
        boolean isValid = bl;
        if (isValid) return;
        context.fail("Method must return void, a Reactive Streams type or a subtype of CompletionStage", element);
    }
}

