/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.Internal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.TableSwitchGenerator;

@Internal
public abstract class StringSwitchWriter {
    protected abstract Set<String> getKeys();

    protected abstract void pushStringValue();

    protected abstract void onMatch(String var1, Label var2);

    protected void generateDefault() {
    }

    public void write(final GeneratorAdapter writer) {
        Set<String> keys = this.getKeys();
        if (keys.isEmpty()) {
            return;
        }
        if (keys.size() == 1) {
            Label end = new Label();
            String key = keys.iterator().next();
            this.generateValueCase(writer, key, end);
            writer.visitLabel(end);
            return;
        }
        final HashMap<Integer, Set> hashToValue = new HashMap<Integer, Set>();
        for (String string : keys) {
            hashToValue.computeIfAbsent(string.hashCode(), hashCode -> new TreeSet()).add(string);
        }
        int[] hashCodeArray = hashToValue.keySet().stream().mapToInt(i -> i).toArray();
        Arrays.sort(hashCodeArray);
        this.pushStringValue();
        writer.invokeVirtual(Type.getType(Object.class), new Method("hashCode", Type.INT_TYPE, new Type[0]));
        writer.tableSwitch(hashCodeArray, new TableSwitchGenerator(){

            public void generateCase(int hashCode, Label end) {
                for (String string : (Set)hashToValue.get(hashCode)) {
                    StringSwitchWriter.this.generateValueCase(writer, string, end);
                }
                writer.goTo(end);
            }

            public void generateDefault() {
                StringSwitchWriter.this.generateDefault();
            }
        });
    }

    protected void generateValueCase(GeneratorAdapter writer, String string, Label end) {
        this.pushStringValue();
        writer.push(string);
        writer.invokeVirtual(Type.getType(Object.class), new Method("equals", Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}));
        writer.push(true);
        Label falseLabel = new Label();
        writer.ifCmp(Type.BOOLEAN_TYPE, 154, falseLabel);
        this.onMatch(string, end);
        writer.visitLabel(falseLabel);
    }
}

