/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.ExecutableMethodsDefinitionWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.TableSwitchGenerator;

@Internal
public final class DispatchWriter
extends AbstractClassFileWriter
implements Opcodes {
    private static final Method DISPATCH_METHOD = new Method("dispatch", DispatchWriter.getMethodDescriptor(Object.class, Arrays.asList(Integer.TYPE, Object.class, Object[].class)));
    private static final Method DISPATCH_ONE_METHOD = new Method("dispatchOne", DispatchWriter.getMethodDescriptor(Object.class, Arrays.asList(Integer.TYPE, Object.class, Object.class)));
    private static final Method GET_TARGET_METHOD = new Method("getTargetMethodByIndex", DispatchWriter.getMethodDescriptor(java.lang.reflect.Method.class, Collections.singletonList(Integer.TYPE)));
    private static final Method GET_ACCESSIBLE_TARGET_METHOD = new Method("getAccessibleTargetMethodByIndex", DispatchWriter.getMethodDescriptor(java.lang.reflect.Method.class, Collections.singletonList(Integer.TYPE)));
    private static final Method UNKNOWN_DISPATCH_AT_INDEX = new Method("unknownDispatchAtIndexException", DispatchWriter.getMethodDescriptor(RuntimeException.class, Collections.singletonList(Integer.TYPE)));
    private static final String FIELD_INTERCEPTABLE = "$interceptable";
    private static final Type TYPE_REFLECTION_UTILS = Type.getType(ReflectionUtils.class);
    private static final Method METHOD_GET_REQUIRED_METHOD = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ReflectionUtils.class, (String)"getRequiredMethod", (Class[])new Class[]{Class.class, String.class, Class[].class}));
    private static final Method METHOD_INVOKE_METHOD = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ReflectionUtils.class, (String)"invokeMethod", (Class[])new Class[]{Object.class, java.lang.reflect.Method.class, Object[].class}));
    private static final Method METHOD_GET_FIELD_VALUE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ReflectionUtils.class, (String)"getField", (Class[])new Class[]{Class.class, String.class, Object.class}));
    private static final Method METHOD_SET_FIELD_VALUE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ReflectionUtils.class, (String)"setField", (Class[])new Class[]{Class.class, String.class, Object.class, Object.class}));
    private final List<DispatchTarget> dispatchTargets = new ArrayList<DispatchTarget>();
    private final Type thisType;
    private final Type dispatchSuperType;
    private boolean hasInterceptedMethod;

    public DispatchWriter(Type thisType) {
        this(thisType, ExecutableMethodsDefinitionWriter.SUPER_TYPE);
    }

    public DispatchWriter(Type thisType, Type dispatchSuperType) {
        super(new Element[0]);
        this.thisType = thisType;
        this.dispatchSuperType = dispatchSuperType;
    }

    public int addSetField(FieldElement beanField) {
        return this.addDispatchTarget(new FieldSetDispatchTarget(beanField));
    }

    public int addGetField(FieldElement beanField) {
        return this.addDispatchTarget(new FieldGetDispatchTarget(beanField));
    }

    public int addMethod(TypedElement declaringType, MethodElement methodElement) {
        return this.addMethod(declaringType, methodElement, false);
    }

    public int addMethod(TypedElement declaringType, MethodElement methodElement, boolean useOneDispatch) {
        return this.addDispatchTarget(new MethodDispatchTarget(this.dispatchSuperType, declaringType, methodElement, useOneDispatch, !useOneDispatch));
    }

    public int addInterceptedMethod(TypedElement declaringType, MethodElement methodElement, String interceptedProxyClassName, String interceptedProxyBridgeMethodName) {
        this.hasInterceptedMethod = true;
        return this.addDispatchTarget(new InterceptableMethodDispatchTarget(this.dispatchSuperType, declaringType, methodElement, interceptedProxyClassName, interceptedProxyBridgeMethodName, this.thisType));
    }

    public int addDispatchTarget(DispatchTarget dispatchTarget) {
        this.dispatchTargets.add(dispatchTarget);
        return this.dispatchTargets.size() - 1;
    }

    public void buildDispatchMethod(ClassWriter classWriter) {
        int[] cases = this.dispatchTargets.stream().filter(DispatchTarget::supportsDispatchMulti).mapToInt(this.dispatchTargets::indexOf).toArray();
        if (cases.length == 0) {
            return;
        }
        final GeneratorAdapter dispatchMethod = new GeneratorAdapter(classWriter.visitMethod(20, DISPATCH_METHOD.getName(), DISPATCH_METHOD.getDescriptor(), null, null), 20, DISPATCH_METHOD.getName(), DISPATCH_METHOD.getDescriptor());
        dispatchMethod.loadArg(0);
        dispatchMethod.tableSwitch(cases, new TableSwitchGenerator(){

            public void generateCase(int key, Label end) {
                DispatchTarget method = DispatchWriter.this.dispatchTargets.get(key);
                method.writeDispatchMulti(dispatchMethod, key);
                dispatchMethod.returnValue();
            }

            public void generateDefault() {
                dispatchMethod.loadThis();
                dispatchMethod.loadArg(0);
                dispatchMethod.invokeVirtual(DispatchWriter.this.thisType, UNKNOWN_DISPATCH_AT_INDEX);
                dispatchMethod.throwException();
            }
        }, true);
        dispatchMethod.visitMaxs(13, 1);
        dispatchMethod.visitEnd();
    }

    public void buildDispatchOneMethod(ClassWriter classWriter) {
        int[] cases = this.dispatchTargets.stream().filter(DispatchTarget::supportsDispatchOne).mapToInt(this.dispatchTargets::indexOf).toArray();
        if (cases.length == 0) {
            return;
        }
        final GeneratorAdapter dispatchMethod = new GeneratorAdapter(classWriter.visitMethod(20, DISPATCH_ONE_METHOD.getName(), DISPATCH_ONE_METHOD.getDescriptor(), null, null), 20, DISPATCH_ONE_METHOD.getName(), DISPATCH_ONE_METHOD.getDescriptor());
        dispatchMethod.loadArg(0);
        dispatchMethod.tableSwitch(cases, new TableSwitchGenerator(){

            public void generateCase(int key, Label end) {
                DispatchTarget method = DispatchWriter.this.dispatchTargets.get(key);
                method.writeDispatchOne(dispatchMethod, key);
                dispatchMethod.returnValue();
            }

            public void generateDefault() {
                dispatchMethod.loadThis();
                dispatchMethod.loadArg(0);
                dispatchMethod.invokeVirtual(DispatchWriter.this.thisType, UNKNOWN_DISPATCH_AT_INDEX);
                dispatchMethod.throwException();
            }
        }, true);
        dispatchMethod.visitMaxs(13, 1);
        dispatchMethod.visitEnd();
    }

    public void buildGetTargetMethodByIndex(ClassWriter classWriter) {
        final GeneratorAdapter getTargetMethodByIndex = new GeneratorAdapter(classWriter.visitMethod(20, GET_TARGET_METHOD.getName(), GET_TARGET_METHOD.getDescriptor(), null, null), 20, GET_TARGET_METHOD.getName(), GET_TARGET_METHOD.getDescriptor());
        getTargetMethodByIndex.loadArg(0);
        int[] cases = this.dispatchTargets.stream().filter(MethodDispatchTarget.class::isInstance).mapToInt(this.dispatchTargets::indexOf).toArray();
        getTargetMethodByIndex.tableSwitch(cases, new TableSwitchGenerator(){

            public void generateCase(int key, Label end) {
                MethodDispatchTarget method = (MethodDispatchTarget)DispatchWriter.this.dispatchTargets.get(key);
                TypedElement declaringType = method.declaringType;
                Type declaringTypeObject = JavaModelUtils.getTypeReference(declaringType);
                MethodElement methodElement = method.methodElement;
                DispatchWriter.pushTypeUtilsGetRequiredMethod(getTargetMethodByIndex, declaringTypeObject, methodElement);
                getTargetMethodByIndex.returnValue();
            }

            public void generateDefault() {
                getTargetMethodByIndex.loadThis();
                getTargetMethodByIndex.loadArg(0);
                getTargetMethodByIndex.invokeVirtual(DispatchWriter.this.thisType, UNKNOWN_DISPATCH_AT_INDEX);
                getTargetMethodByIndex.throwException();
            }
        }, true);
        getTargetMethodByIndex.visitMaxs(13, 1);
        getTargetMethodByIndex.visitEnd();
    }

    public static void pushTypeUtilsGetRequiredMethod(GeneratorAdapter builder, Type declaringTypeObject, MethodElement methodElement) {
        List<ParameterElement> argumentTypes = Arrays.asList(methodElement.getSuspendParameters());
        builder.push(declaringTypeObject);
        builder.push(methodElement.getName());
        if (!argumentTypes.isEmpty()) {
            int len = argumentTypes.size();
            Iterator<ParameterElement> iter = argumentTypes.iterator();
            DispatchWriter.pushNewArray(builder, Class.class, len);
            for (int i = 0; i < len; ++i) {
                ParameterElement type = iter.next();
                DispatchWriter.pushStoreInArray(builder, i, len, () -> builder.push(JavaModelUtils.getTypeReference(type)));
            }
        } else {
            builder.getStatic(TYPE_REFLECTION_UTILS, "EMPTY_CLASS_ARRAY", Type.getType(Class[].class));
        }
        builder.invokeStatic(TYPE_REFLECTION_UTILS, METHOD_GET_REQUIRED_METHOD);
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        throw new IllegalStateException();
    }

    public List<DispatchTarget> getDispatchTargets() {
        return this.dispatchTargets;
    }

    public boolean isHasInterceptedMethod() {
        return this.hasInterceptedMethod;
    }

    @Internal
    public static final class FieldSetDispatchTarget
    implements DispatchTarget {
        @NonNull
        final FieldElement beanField;

        public FieldSetDispatchTarget(FieldElement beanField) {
            this.beanField = beanField;
        }

        @Override
        public boolean supportsDispatchOne() {
            return true;
        }

        @Override
        public boolean supportsDispatchMulti() {
            return false;
        }

        @Override
        public void writeDispatchOne(GeneratorAdapter writer, int fieldIndex) {
            Type propertyType = JavaModelUtils.getTypeReference(this.beanField.getType());
            Type beanType = JavaModelUtils.getTypeReference(this.beanField.getOwningType());
            if (this.beanField.isReflectionRequired()) {
                writer.push(beanType);
                writer.push(this.beanField.getName());
                writer.loadArg(1);
                writer.loadArg(2);
                writer.invokeStatic(TYPE_REFLECTION_UTILS, METHOD_SET_FIELD_VALUE);
            } else {
                writer.loadArg(1);
                AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, beanType);
                writer.loadArg(2);
                AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, propertyType);
                writer.putField(beanType, this.beanField.getName(), propertyType);
            }
            writer.push((String)null);
        }

        @NonNull
        public FieldElement getField() {
            return this.beanField;
        }
    }

    @Internal
    public static interface DispatchTarget {
        default public boolean supportsDispatchOne() {
            return false;
        }

        default public void writeDispatchOne(GeneratorAdapter writer, int methodIndex) {
            throw new IllegalStateException("Not supported");
        }

        default public boolean supportsDispatchMulti() {
            return false;
        }

        default public void writeDispatchMulti(GeneratorAdapter writer, int methodIndex) {
            throw new IllegalStateException("Not supported");
        }
    }

    @Internal
    public static final class FieldGetDispatchTarget
    implements DispatchTarget {
        @NonNull
        final FieldElement beanField;

        public FieldGetDispatchTarget(FieldElement beanField) {
            this.beanField = beanField;
        }

        @Override
        public boolean supportsDispatchOne() {
            return true;
        }

        @Override
        public boolean supportsDispatchMulti() {
            return false;
        }

        @Override
        public void writeDispatchOne(GeneratorAdapter writer, int fieldIndex) {
            Type propertyType = JavaModelUtils.getTypeReference(this.beanField.getType());
            Type beanType = JavaModelUtils.getTypeReference(this.beanField.getOwningType());
            if (this.beanField.isReflectionRequired()) {
                writer.push(beanType);
                writer.push(this.beanField.getName());
                writer.loadArg(1);
                writer.invokeStatic(TYPE_REFLECTION_UTILS, METHOD_GET_FIELD_VALUE);
                if (this.beanField.isPrimitive()) {
                    AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, propertyType);
                }
            } else {
                writer.loadArg(1);
                AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, beanType);
                writer.getField(JavaModelUtils.getTypeReference(this.beanField.getOwningType()), this.beanField.getName(), propertyType);
            }
            AbstractClassFileWriter.pushBoxPrimitiveIfNecessary(propertyType, (MethodVisitor)writer);
        }

        @NonNull
        public FieldElement getField() {
            return this.beanField;
        }
    }

    @Internal
    public static class MethodDispatchTarget
    implements DispatchTarget {
        final Type dispatchSuperType;
        final TypedElement declaringType;
        final MethodElement methodElement;
        final boolean oneDispatch;
        final boolean multiDispatch;

        private MethodDispatchTarget(Type dispatchSuperType, TypedElement declaringType, MethodElement methodElement, boolean oneDispatch, boolean multiDispatch) {
            this.dispatchSuperType = dispatchSuperType;
            this.declaringType = declaringType;
            this.methodElement = methodElement;
            this.oneDispatch = oneDispatch;
            this.multiDispatch = multiDispatch;
        }

        public MethodElement getMethodElement() {
            return this.methodElement;
        }

        @Override
        public boolean supportsDispatchOne() {
            return this.oneDispatch;
        }

        @Override
        public boolean supportsDispatchMulti() {
            return this.multiDispatch;
        }

        @Override
        public void writeDispatchMulti(GeneratorAdapter writer, int methodIndex) {
            this.writeDispatch(writer, methodIndex, true);
        }

        @Override
        public void writeDispatchOne(GeneratorAdapter writer, int methodIndex) {
            this.writeDispatch(writer, methodIndex, false);
        }

        private void writeDispatch(GeneratorAdapter writer, int methodIndex, boolean isMulti) {
            boolean hasArgs;
            String methodName = this.methodElement.getName();
            List<ParameterElement> argumentTypes = Arrays.asList(this.methodElement.getSuspendParameters());
            Type declaringTypeObject = JavaModelUtils.getTypeReference(this.declaringType);
            boolean reflectionRequired = this.methodElement.isReflectionRequired();
            ClassElement returnType = this.methodElement.isSuspend() ? ClassElement.of(Object.class) : this.methodElement.getReturnType();
            boolean isInterface = this.declaringType.getType().isInterface();
            Type returnTypeObject = JavaModelUtils.getTypeReference(returnType);
            boolean bl = hasArgs = !argumentTypes.isEmpty();
            if (!this.methodElement.isStatic()) {
                writer.loadArg(1);
            }
            if (reflectionRequired) {
                if (this.methodElement.isStatic()) {
                    writer.push((String)null);
                }
                writer.loadThis();
                writer.push(methodIndex);
                writer.invokeVirtual(this.dispatchSuperType, GET_ACCESSIBLE_TARGET_METHOD);
                if (hasArgs) {
                    if (isMulti) {
                        writer.loadArg(2);
                    } else {
                        writer.push(1);
                        writer.newArray(Type.getType(Object.class));
                        writer.dup();
                        writer.push(0);
                        writer.loadArg(2);
                        writer.visitInsn(83);
                    }
                } else {
                    writer.getStatic(Type.getType(ArrayUtils.class), "EMPTY_OBJECT_ARRAY", Type.getType(Object[].class));
                }
                writer.invokeStatic(TYPE_REFLECTION_UTILS, METHOD_INVOKE_METHOD);
            } else {
                if (!this.methodElement.isStatic()) {
                    AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, declaringTypeObject);
                }
                if (hasArgs) {
                    if (isMulti) {
                        int argCount = argumentTypes.size();
                        Iterator<ParameterElement> argIterator = argumentTypes.iterator();
                        for (int i = 0; i < argCount; ++i) {
                            writer.loadArg(2);
                            writer.push(i);
                            writer.visitInsn(50);
                            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, argIterator.next());
                        }
                    } else {
                        writer.loadArg(2);
                        AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, argumentTypes.iterator().next());
                    }
                }
                String methodDescriptor = AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes);
                if (this.methodElement.isStatic()) {
                    writer.invokeStatic(declaringTypeObject, new Method(methodName, methodDescriptor));
                } else {
                    writer.visitMethodInsn(isInterface ? 185 : 182, declaringTypeObject.getInternalName(), methodName, methodDescriptor, isInterface);
                }
            }
            if (returnTypeObject.equals((Object)Type.VOID_TYPE)) {
                writer.push((String)null);
            } else if (!reflectionRequired) {
                AbstractClassFileWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)writer);
            }
        }
    }

    @Internal
    public static final class InterceptableMethodDispatchTarget
    extends MethodDispatchTarget {
        final String interceptedProxyClassName;
        final String interceptedProxyBridgeMethodName;
        final Type thisType;

        private InterceptableMethodDispatchTarget(Type dispatchSuperType, TypedElement declaringType, MethodElement methodElement, String interceptedProxyClassName, String interceptedProxyBridgeMethodName, Type thisType) {
            super(dispatchSuperType, declaringType, methodElement, false, true);
            this.interceptedProxyClassName = interceptedProxyClassName;
            this.interceptedProxyBridgeMethodName = interceptedProxyBridgeMethodName;
            this.thisType = thisType;
        }

        @Override
        public void writeDispatchMulti(GeneratorAdapter writer, int methodIndex) {
            boolean hasArgs;
            String methodName = this.methodElement.getName();
            List<ParameterElement> argumentTypes = Arrays.asList(this.methodElement.getSuspendParameters());
            Type declaringTypeObject = JavaModelUtils.getTypeReference(this.declaringType);
            ClassElement returnType = this.methodElement.isSuspend() ? ClassElement.of(Object.class) : this.methodElement.getReturnType();
            boolean isInterface = this.declaringType.getType().isInterface();
            Type returnTypeObject = JavaModelUtils.getTypeReference(returnType);
            writer.loadArg(1);
            writer.dup();
            String methodDescriptor = AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes);
            Label invokeTargetBlock = new Label();
            Type interceptedProxyType = AbstractClassFileWriter.getObjectType(this.interceptedProxyClassName);
            writer.loadThis();
            writer.getField(this.thisType, DispatchWriter.FIELD_INTERCEPTABLE, Type.getType(Boolean.TYPE));
            writer.push(true);
            writer.ifCmp(Type.BOOLEAN_TYPE, 154, invokeTargetBlock);
            writer.loadArg(1);
            writer.instanceOf(interceptedProxyType);
            writer.push(true);
            writer.ifCmp(Type.BOOLEAN_TYPE, 154, invokeTargetBlock);
            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, interceptedProxyType);
            Iterator<ParameterElement> iterator = argumentTypes.iterator();
            for (int i = 0; i < argumentTypes.size(); ++i) {
                writer.loadArg(2);
                writer.push(i);
                writer.visitInsn(50);
                AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, iterator.next());
            }
            writer.visitMethodInsn(182, interceptedProxyType.getInternalName(), this.interceptedProxyBridgeMethodName, methodDescriptor, false);
            if (returnTypeObject.equals((Object)Type.VOID_TYPE)) {
                writer.visitInsn(1);
            } else {
                AbstractClassFileWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)writer);
            }
            writer.returnValue();
            writer.visitLabel(invokeTargetBlock);
            writer.pop();
            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, declaringTypeObject);
            boolean bl = hasArgs = !argumentTypes.isEmpty();
            if (hasArgs) {
                int argCount = argumentTypes.size();
                Iterator<ParameterElement> argIterator = argumentTypes.iterator();
                for (int i = 0; i < argCount; ++i) {
                    writer.loadArg(2);
                    writer.push(i);
                    writer.visitInsn(50);
                    AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, argIterator.next());
                }
            }
            writer.visitMethodInsn(isInterface ? 185 : 182, declaringTypeObject.getInternalName(), methodName, methodDescriptor, isInterface);
            if (returnTypeObject.equals((Object)Type.VOID_TYPE)) {
                writer.visitInsn(1);
            } else {
                AbstractClassFileWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)writer);
            }
        }
    }
}

