/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassOutputWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.DirectoryClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.inject.writer.OriginatingElements;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public abstract class AbstractClassFileWriter
implements Opcodes,
OriginatingElements,
ClassOutputWriter {
    protected static final Type TYPE_ARGUMENT;
    protected static final Type TYPE_ARGUMENT_ARRAY;
    protected static final String ZERO_ARGUMENTS_CONSTANT = "ZERO_ARGUMENTS";
    protected static final String CONSTRUCTOR_NAME = "<init>";
    protected static final String DESCRIPTOR_DEFAULT_CONSTRUCTOR = "()V";
    protected static final Method METHOD_DEFAULT_CONSTRUCTOR;
    protected static final Type TYPE_OBJECT;
    protected static final Type TYPE_CLASS;
    protected static final int DEFAULT_MAX_STACK = 13;
    protected static final Type TYPE_GENERATED;
    protected static final Pattern ARRAY_PATTERN;
    protected static final Method METHOD_CREATE_ARGUMENT_SIMPLE;
    protected static final Method METHOD_GENERIC_PLACEHOLDER_SIMPLE;
    protected static final Method METHOD_CREATE_TYPE_VARIABLE_SIMPLE;
    private static final Method METHOD_CREATE_ARGUMENT_WITH_ANNOTATION_METADATA_GENERICS;
    private static final Method METHOD_CREATE_TYPE_VAR_WITH_ANNOTATION_METADATA_GENERICS;
    private static final Method METHOD_CREATE_GENERIC_PLACEHOLDER_WITH_ANNOTATION_METADATA_GENERICS;
    private static final Method METHOD_CREATE_ARGUMENT_WITH_ANNOTATION_METADATA_CLASS_GENERICS;
    private static final Type MAP_TYPE;
    private static final Type LIST_TYPE;
    private static final Method[] MAP_OF;
    private static final Method[] LIST_OF;
    private static final Method MAP_BY_ARRAY;
    private static final Method MAP_ENTRY;
    private static final Method LIST_BY_ARRAY;
    protected final OriginatingElements originatingElements;

    protected AbstractClassFileWriter(Element ... originatingElements) {
        this(OriginatingElements.of(originatingElements));
    }

    protected AbstractClassFileWriter(OriginatingElements originatingElements) {
        this.originatingElements = Objects.requireNonNull(originatingElements, "The originating elements cannot be null");
    }

    @Override
    @NonNull
    public Element[] getOriginatingElements() {
        return this.originatingElements.getOriginatingElements();
    }

    @Override
    public void addOriginatingElement(@NonNull Element element) {
        this.originatingElements.addOriginatingElement(element);
    }

    protected static void pushTypeArgumentElements(AnnotationMetadata annotationMetadataWithDefaults, Type owningType, ClassWriter owningTypeWriter, GeneratorAdapter generatorAdapter, String declaringElementName, Map<String, ClassElement> types, Map<String, Integer> defaults, Map<String, GeneratorAdapter> loadTypeMethods) {
        if (types == null || types.isEmpty()) {
            AbstractClassFileWriter.pushNewArray(generatorAdapter, Argument.class, 0);
            return;
        }
        AbstractClassFileWriter.pushTypeArgumentElements(annotationMetadataWithDefaults, owningType, owningTypeWriter, generatorAdapter, declaringElementName, null, types, new HashSet<Object>(5), defaults, loadTypeMethods);
    }

    private static void pushTypeArgumentElements(AnnotationMetadata annotationMetadataWithDefaults, Type owningType, ClassWriter declaringClassWriter, GeneratorAdapter generatorAdapter, String declaringElementName, @Nullable ClassElement element, Map<String, ClassElement> types, Set<Object> visitedTypes, Map<String, Integer> defaults, Map<String, GeneratorAdapter> loadTypeMethods) {
        if (element == null) {
            if (visitedTypes.contains(declaringElementName)) {
                generatorAdapter.getStatic(TYPE_ARGUMENT, ZERO_ARGUMENTS_CONSTANT, TYPE_ARGUMENT_ARRAY);
                return;
            }
            visitedTypes.add(declaringElementName);
        }
        int len = types.size();
        AbstractClassFileWriter.pushNewArray(generatorAdapter, Argument.class, len);
        int i = 0;
        for (Map.Entry<String, ClassElement> entry : types.entrySet()) {
            generatorAdapter.push(i);
            String argumentName = entry.getKey();
            ClassElement classElement = entry.getValue();
            Type classReference = JavaModelUtils.getTypeReference(classElement);
            Map<String, ClassElement> typeArguments = classElement.getTypeArguments();
            if (CollectionUtils.isNotEmpty(typeArguments) || !classElement.getAnnotationMetadata().isEmpty()) {
                AbstractClassFileWriter.buildArgumentWithGenerics(annotationMetadataWithDefaults, owningType, declaringClassWriter, generatorAdapter, argumentName, classReference, classElement, typeArguments, visitedTypes, defaults, loadTypeMethods);
            } else {
                AbstractClassFileWriter.buildArgument(generatorAdapter, argumentName, classElement);
            }
            generatorAdapter.visitInsn(83);
            if (i != len - 1) {
                generatorAdapter.visitInsn(89);
            }
            ++i;
        }
    }

    protected static void buildArgument(GeneratorAdapter generatorAdapter, String argumentName, Type objectType) {
        generatorAdapter.push(objectType);
        generatorAdapter.push(argumentName);
        AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, METHOD_CREATE_ARGUMENT_SIMPLE);
    }

    protected static void buildArgument(GeneratorAdapter generatorAdapter, String argumentName, ClassElement objectType) {
        generatorAdapter.push(AbstractClassFileWriter.getTypeReference(objectType));
        generatorAdapter.push(argumentName);
        if (objectType instanceof GenericPlaceholderElement) {
            GenericPlaceholderElement placeholderElement = (GenericPlaceholderElement)objectType;
            objectType = placeholderElement.getResolved().orElse(placeholderElement);
        }
        if (objectType instanceof GenericPlaceholderElement || objectType.isTypeVariable()) {
            boolean hasVariable;
            String variableName = argumentName;
            if (objectType instanceof GenericPlaceholderElement) {
                GenericPlaceholderElement placeholderElement = (GenericPlaceholderElement)objectType;
                variableName = placeholderElement.getVariableName();
            }
            boolean bl = hasVariable = !variableName.equals(argumentName);
            if (hasVariable) {
                generatorAdapter.push(variableName);
            }
            AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, hasVariable ? METHOD_GENERIC_PLACEHOLDER_SIMPLE : METHOD_CREATE_TYPE_VARIABLE_SIMPLE);
        } else {
            AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, METHOD_CREATE_ARGUMENT_SIMPLE);
        }
    }

    protected static void buildArgumentWithGenerics(AnnotationMetadata annotationMetadataWithDefaults, Type owningType, ClassWriter owningClassWriter, GeneratorAdapter generatorAdapter, String argumentName, Type typeReference, ClassElement classElement, Map<String, ClassElement> typeArguments, Set<Object> visitedTypes, Map<String, Integer> defaults, Map<String, GeneratorAdapter> loadTypeMethods) {
        MutableAnnotationMetadata annotationMetadata;
        generatorAdapter.push(typeReference);
        generatorAdapter.push(argumentName);
        if (classElement instanceof GenericPlaceholderElement) {
            GenericPlaceholderElement placeholderElement = (GenericPlaceholderElement)classElement;
            classElement = placeholderElement.getResolved().orElse(classElement);
        }
        boolean hasAnnotationMetadata = !(annotationMetadata = MutableAnnotationMetadata.of(classElement.getTypeAnnotationMetadata())).isEmpty();
        boolean isRecursiveType = false;
        if (classElement instanceof GenericPlaceholderElement) {
            GenericPlaceholderElement placeholderElement = (GenericPlaceholderElement)classElement;
            Object genericNativeType = placeholderElement.getGenericNativeType();
            if (visitedTypes.contains(genericNativeType)) {
                isRecursiveType = true;
            } else {
                visitedTypes.add(genericNativeType);
            }
        }
        boolean typeVariable = classElement.isTypeVariable();
        if (isRecursiveType || !typeVariable && !hasAnnotationMetadata && typeArguments.isEmpty()) {
            AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, METHOD_CREATE_ARGUMENT_SIMPLE);
            return;
        }
        if (!hasAnnotationMetadata) {
            generatorAdapter.visitInsn(1);
        } else {
            MutableAnnotationMetadata.contributeDefaults((AnnotationMetadata)annotationMetadataWithDefaults, (AnnotationMetadata)annotationMetadata);
            AnnotationMetadataWriter.instantiateNewMetadata(owningType, owningClassWriter, generatorAdapter, annotationMetadata, defaults, loadTypeMethods);
        }
        AbstractClassFileWriter.pushTypeArgumentElements(annotationMetadataWithDefaults, owningType, owningClassWriter, generatorAdapter, classElement.getName(), classElement, typeArguments, visitedTypes, defaults, loadTypeMethods);
        AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, typeVariable ? METHOD_CREATE_TYPE_VAR_WITH_ANNOTATION_METADATA_GENERICS : METHOD_CREATE_ARGUMENT_WITH_ANNOTATION_METADATA_GENERICS);
    }

    protected static void buildArgumentWithGenerics(GeneratorAdapter generatorAdapter, Type type, AnnotationMetadataReference annotationMetadata, ClassElement[] generics) {
        generatorAdapter.push(type);
        AnnotationMetadataWriter.pushAnnotationMetadataReference(generatorAdapter, annotationMetadata);
        AbstractClassFileWriter.pushNewArray(generatorAdapter, Class.class, generics.length);
        int len = generics.length;
        for (int i = 0; i < len; ++i) {
            ClassElement generic = generics[i];
            AbstractClassFileWriter.pushStoreInArray(generatorAdapter, i, len, () -> generatorAdapter.push(AbstractClassFileWriter.getTypeReference(generic)));
        }
        AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, METHOD_CREATE_ARGUMENT_WITH_ANNOTATION_METADATA_CLASS_GENERICS);
    }

    protected static void pushBuildArgumentsForMethod(AnnotationMetadata annotationMetadataWithDefaults, String declaringElementName, Type owningType, ClassWriter declaringClassWriter, GeneratorAdapter generatorAdapter, Collection<ParameterElement> argumentTypes, Map<String, Integer> defaults, Map<String, GeneratorAdapter> loadTypeMethods) {
        int len = argumentTypes.size();
        AbstractClassFileWriter.pushNewArray(generatorAdapter, Argument.class, len);
        int i = 0;
        for (ParameterElement entry : argumentTypes) {
            generatorAdapter.push(i);
            ClassElement genericType = entry.getGenericType();
            MutableAnnotationMetadata.contributeDefaults((AnnotationMetadata)annotationMetadataWithDefaults, (AnnotationMetadata)entry.getAnnotationMetadata());
            MutableAnnotationMetadata.contributeDefaults((AnnotationMetadata)annotationMetadataWithDefaults, genericType.getTypeAnnotationMetadata());
            String argumentName = entry.getName();
            MutableAnnotationMetadata annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{entry.getAnnotationMetadata(), genericType.getTypeAnnotationMetadata()}).merge();
            Map<String, ClassElement> typeArguments = genericType.getTypeArguments();
            AbstractClassFileWriter.pushCreateArgument(annotationMetadataWithDefaults, declaringElementName, owningType, declaringClassWriter, generatorAdapter, argumentName, genericType, (AnnotationMetadata)annotationMetadata, typeArguments, defaults, loadTypeMethods);
            generatorAdapter.visitInsn(83);
            if (i != len - 1) {
                generatorAdapter.visitInsn(89);
            }
            ++i;
        }
    }

    protected void pushReturnTypeArgument(AnnotationMetadata annotationMetadataWithDefaults, Type owningType, ClassWriter classWriter, GeneratorAdapter generatorAdapter, String declaringTypeName, ClassElement argument, Map<String, Integer> defaults, Map<String, GeneratorAdapter> loadTypeMethods) {
        MutableAnnotationMetadataDelegate<AnnotationMetadata> annotationMetadata = argument.getTypeAnnotationMetadata();
        if (argument.isVoid()) {
            Type type = Type.getType(Argument.class);
            generatorAdapter.getStatic(type, "VOID", type);
            return;
        }
        if (argument.isPrimitive() && !argument.isArray()) {
            String constantName = argument.getName().toUpperCase(Locale.ENGLISH);
            Type type = Type.getType(Argument.class);
            generatorAdapter.getStatic(type, constantName, type);
            return;
        }
        if (annotationMetadata.isEmpty() && !argument.isArray() && String.class.getName().equals(argument.getType().getName()) && argument.getName().equals(argument.getType().getName()) && argument.getAnnotationMetadata().isEmpty()) {
            Type type = Type.getType(Argument.class);
            generatorAdapter.getStatic(type, "STRING", type);
            return;
        }
        AbstractClassFileWriter.pushCreateArgument(annotationMetadataWithDefaults, declaringTypeName, owningType, classWriter, generatorAdapter, argument.getName(), argument, annotationMetadata, argument.getTypeArguments(), defaults, loadTypeMethods);
    }

    protected static void pushCreateArgument(AnnotationMetadata annotationMetadataWithDefaults, String declaringTypeName, Type owningType, ClassWriter declaringClassWriter, GeneratorAdapter generatorAdapter, String argumentName, TypedElement typedElement, AnnotationMetadata annotationMetadata, Map<String, ClassElement> typeArguments, Map<String, Integer> defaults, Map<String, GeneratorAdapter> loadTypeMethods) {
        boolean hasVariableName;
        ClassElement classElement;
        boolean isGenericPlaceholder;
        boolean hasTypeArguments;
        annotationMetadata = MutableAnnotationMetadata.of((AnnotationMetadata)annotationMetadata);
        Type argumentType = JavaModelUtils.getTypeReference(typedElement);
        generatorAdapter.push(argumentType);
        generatorAdapter.push(argumentName);
        boolean hasAnnotations = !annotationMetadata.isEmpty();
        boolean bl = hasTypeArguments = typeArguments != null && !typeArguments.isEmpty();
        if (typedElement instanceof GenericPlaceholderElement) {
            GenericPlaceholderElement placeholderElement = (GenericPlaceholderElement)typedElement;
            typedElement = placeholderElement.getResolved().orElse(placeholderElement);
        }
        boolean isTypeVariable = (isGenericPlaceholder = typedElement instanceof GenericPlaceholderElement) || typedElement instanceof ClassElement && (classElement = (ClassElement)typedElement).isTypeVariable();
        String variableName = argumentName;
        if (isGenericPlaceholder) {
            variableName = ((GenericPlaceholderElement)typedElement).getVariableName();
        }
        boolean bl2 = hasVariableName = !variableName.equals(argumentName);
        if (!(hasAnnotations || hasTypeArguments || isTypeVariable)) {
            AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, METHOD_CREATE_ARGUMENT_SIMPLE);
            return;
        }
        if (isTypeVariable && hasVariableName) {
            generatorAdapter.push(variableName);
        }
        if (hasAnnotations) {
            MutableAnnotationMetadata.contributeDefaults((AnnotationMetadata)annotationMetadataWithDefaults, (AnnotationMetadata)annotationMetadata);
            AnnotationMetadataWriter.instantiateNewMetadata(owningType, declaringClassWriter, generatorAdapter, (MutableAnnotationMetadata)annotationMetadata, defaults, loadTypeMethods);
        } else {
            generatorAdapter.visitInsn(1);
        }
        if (hasTypeArguments) {
            AbstractClassFileWriter.pushTypeArgumentElements(annotationMetadataWithDefaults, owningType, declaringClassWriter, generatorAdapter, declaringTypeName, typeArguments, defaults, loadTypeMethods);
        } else {
            generatorAdapter.visitInsn(1);
        }
        if (isTypeVariable) {
            AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, hasVariableName ? METHOD_CREATE_GENERIC_PLACEHOLDER_WITH_ANNOTATION_METADATA_GENERICS : METHOD_CREATE_TYPE_VAR_WITH_ANNOTATION_METADATA_GENERICS);
        } else {
            AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, METHOD_CREATE_ARGUMENT_WITH_ANNOTATION_METADATA_GENERICS);
        }
    }

    public void writeTo(File targetDir) throws IOException {
        this.accept(this.newClassWriterOutputVisitor(targetDir));
    }

    protected void writeBooleanMethod(ClassWriter classWriter, String methodName, Supplier<Boolean> valueSupplier) {
        GeneratorAdapter isSingletonMethod = this.startPublicMethodZeroArgs(classWriter, Boolean.TYPE, methodName);
        isSingletonMethod.loadThis();
        isSingletonMethod.push(valueSupplier.get().booleanValue());
        isSingletonMethod.returnValue();
        isSingletonMethod.visitMaxs(1, 1);
        isSingletonMethod.visitEnd();
    }

    @Nullable
    public Element getOriginatingElement() {
        Object[] originatingElements = this.getOriginatingElements();
        if (ArrayUtils.isNotEmpty((Object[])originatingElements)) {
            return originatingElements[0];
        }
        return null;
    }

    protected void implementInterceptedTypeMethod(Type interceptedType, ClassWriter classWriter) {
        GeneratorAdapter getTargetTypeMethod = this.startPublicMethodZeroArgs(classWriter, Class.class, "getInterceptedType");
        getTargetTypeMethod.loadThis();
        getTargetTypeMethod.push(interceptedType);
        getTargetTypeMethod.returnValue();
        getTargetTypeMethod.visitMaxs(1, 1);
        getTargetTypeMethod.visitEnd();
    }

    protected static String getTypeDescriptor(TypedElement type) {
        return JavaModelUtils.getTypeReference(type).getDescriptor();
    }

    protected static String getTypeDescriptor(Class<?> type) {
        return Type.getDescriptor(type);
    }

    protected static String getTypeDescriptor(String type) {
        return AbstractClassFileWriter.getTypeDescriptor(type, new String[0]);
    }

    protected static Type getTypeReferenceForName(String className, String ... genericTypes) {
        String referenceString = AbstractClassFileWriter.getTypeDescriptor(className, genericTypes);
        return Type.getType((String)referenceString);
    }

    protected static Type getTypeReference(TypedElement type) {
        return JavaModelUtils.getTypeReference(type);
    }

    protected static void pushBoxPrimitiveIfNecessary(Type fieldType, MethodVisitor injectMethodVisitor) {
        Optional pt = ClassUtils.getPrimitiveType((String)fieldType.getClassName());
        Class wrapperType = pt.map(ReflectionUtils::getWrapperType).orElse(null);
        if (wrapperType != null && wrapperType != Void.class) {
            Type wrapper = Type.getType((Class)wrapperType);
            String primitiveName = fieldType.getClassName();
            String sig = wrapperType.getName() + " valueOf(" + primitiveName + ")";
            Method valueOfMethod = Method.getMethod((String)sig);
            injectMethodVisitor.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", valueOfMethod.getDescriptor(), false);
        }
    }

    protected static void pushBoxPrimitiveIfNecessary(Class<?> fieldType, MethodVisitor injectMethodVisitor) {
        Class wrapperType = ReflectionUtils.getWrapperType(fieldType);
        if (wrapperType != null && wrapperType != Void.class) {
            Type wrapper = Type.getType((Class)wrapperType);
            String primitiveName = fieldType.getName();
            String sig = wrapperType.getName() + " valueOf(" + primitiveName + ")";
            Method valueOfMethod = Method.getMethod((String)sig);
            injectMethodVisitor.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", valueOfMethod.getDescriptor(), false);
        }
    }

    protected static void pushBoxPrimitiveIfNecessary(TypedElement fieldType, MethodVisitor injectMethodVisitor) {
        String primitiveName;
        Optional pt;
        Class wrapperType;
        ClassElement type = fieldType.getType();
        if (type.isPrimitive() && !type.isArray() && (wrapperType = (Class)(pt = ClassUtils.getPrimitiveType((String)(primitiveName = type.getName()))).map(ReflectionUtils::getWrapperType).orElse(null)) != null && wrapperType != Void.class) {
            Type wrapper = Type.getType((Class)wrapperType);
            String sig = wrapperType.getName() + " valueOf(" + primitiveName + ")";
            Method valueOfMethod = Method.getMethod((String)sig);
            injectMethodVisitor.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", valueOfMethod.getDescriptor(), false);
        }
    }

    protected static void pushCastToType(MethodVisitor methodVisitor, Type type) {
        String internalName = AbstractClassFileWriter.getInternalNameForCast(type);
        methodVisitor.visitTypeInsn(192, internalName);
        Type primitiveType = null;
        Optional pt = ClassUtils.getPrimitiveType((String)type.getClassName());
        if (pt.isPresent()) {
            primitiveType = Type.getType((Class)((Class)pt.get()));
        }
        AbstractClassFileWriter.pushPrimitiveCastIfRequired(methodVisitor, internalName, primitiveType);
    }

    private static void pushPrimitiveCastIfRequired(MethodVisitor methodVisitor, String internalName, Type primitiveType) {
        if (primitiveType != null) {
            Method valueMethod = null;
            switch (primitiveType.getSort()) {
                case 1: {
                    valueMethod = Method.getMethod((String)"boolean booleanValue()");
                    break;
                }
                case 2: {
                    valueMethod = Method.getMethod((String)"char charValue()");
                    break;
                }
                case 3: {
                    valueMethod = Method.getMethod((String)"byte byteValue()");
                    break;
                }
                case 4: {
                    valueMethod = Method.getMethod((String)"short shortValue()");
                    break;
                }
                case 5: {
                    valueMethod = Method.getMethod((String)"int intValue()");
                    break;
                }
                case 7: {
                    valueMethod = Method.getMethod((String)"long longValue()");
                    break;
                }
                case 8: {
                    valueMethod = Method.getMethod((String)"double doubleValue()");
                    break;
                }
                case 6: {
                    valueMethod = Method.getMethod((String)"float floatValue()");
                    break;
                }
            }
            if (valueMethod != null) {
                methodVisitor.visitMethodInsn(182, internalName, valueMethod.getName(), valueMethod.getDescriptor(), false);
            }
        }
    }

    protected static void pushCastToType(MethodVisitor methodVisitor, TypedElement type) {
        Optional pt;
        String internalName = AbstractClassFileWriter.getInternalNameForCast(type);
        methodVisitor.visitTypeInsn(192, internalName);
        Type primitiveType = null;
        if (type.isPrimitive() && !type.isArray() && (pt = ClassUtils.getPrimitiveType((String)type.getType().getName())).isPresent()) {
            primitiveType = Type.getType((Class)((Class)pt.get()));
        }
        AbstractClassFileWriter.pushPrimitiveCastIfRequired(methodVisitor, internalName, primitiveType);
    }

    protected static void pushCastToType(MethodVisitor methodVisitor, Class<?> type) {
        String internalName = AbstractClassFileWriter.getInternalNameForCast(type);
        methodVisitor.visitTypeInsn(192, internalName);
        Type primitiveType = null;
        if (type.isPrimitive()) {
            primitiveType = Type.getType(type);
        }
        AbstractClassFileWriter.pushPrimitiveCastIfRequired(methodVisitor, internalName, primitiveType);
    }

    protected static void pushReturnValue(MethodVisitor methodVisitor, TypedElement type) {
        Class primitiveTypeClass = null;
        if (type.isPrimitive() && !type.isArray()) {
            primitiveTypeClass = ClassUtils.getPrimitiveType((String)type.getType().getName()).orElse(null);
        }
        if (primitiveTypeClass == null) {
            methodVisitor.visitInsn(176);
        } else {
            Type primitiveType = Type.getType(primitiveTypeClass);
            switch (primitiveType.getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    methodVisitor.visitInsn(172);
                    break;
                }
                case 0: {
                    methodVisitor.visitInsn(177);
                    break;
                }
                case 7: {
                    methodVisitor.visitInsn(173);
                    break;
                }
                case 8: {
                    methodVisitor.visitInsn(175);
                    break;
                }
                case 6: {
                    methodVisitor.visitInsn(174);
                    break;
                }
            }
        }
    }

    protected static void pushMethodNameAndTypesArguments(GeneratorAdapter methodVisitor, String methodName, Collection<ClassElement> argumentTypes) {
        methodVisitor.visitLdcInsn((Object)methodName);
        int argTypeCount = argumentTypes.size();
        if (!argumentTypes.isEmpty()) {
            AbstractClassFileWriter.pushNewArray(methodVisitor, Class.class, argTypeCount);
            Iterator<ClassElement> argIterator = argumentTypes.iterator();
            for (int i = 0; i < argTypeCount; ++i) {
                AbstractClassFileWriter.pushStoreTypeInArray(methodVisitor, i, argTypeCount, argIterator.next());
            }
        } else {
            AbstractClassFileWriter.pushNewArray(methodVisitor, Class.class, 0);
        }
    }

    protected static void pushNewArray(GeneratorAdapter methodVisitor, Class<?> arrayType, int size) {
        Type t = Type.getType(arrayType);
        AbstractClassFileWriter.pushNewArray(methodVisitor, t, size);
    }

    protected static void pushNewArray(GeneratorAdapter methodVisitor, Type arrayType, int size) {
        methodVisitor.push(size);
        methodVisitor.newArray(arrayType);
        if (size > 0) {
            methodVisitor.visitInsn(89);
        }
    }

    protected static void pushStoreStringInArray(GeneratorAdapter methodVisitor, int index, int size, String string) {
        methodVisitor.push(index);
        methodVisitor.push(string);
        methodVisitor.visitInsn(83);
        if (index != size - 1) {
            methodVisitor.dup();
        }
    }

    protected static void pushStoreInArray(GeneratorAdapter methodVisitor, int index, int size, Runnable runnable) {
        AbstractClassFileWriter.pushStoreInArray(methodVisitor, TYPE_OBJECT, index, size, runnable);
    }

    protected static void pushStoreInArray(GeneratorAdapter methodVisitor, Type type, int index, int size, Runnable runnable) {
        methodVisitor.push(index);
        runnable.run();
        methodVisitor.arrayStore(type);
        if (index != size - 1) {
            methodVisitor.dup();
        }
    }

    protected static void pushStoreTypeInArray(GeneratorAdapter methodVisitor, int index, int size, ClassElement type) {
        methodVisitor.push(index);
        if (type.isPrimitive()) {
            Class typeClass = ClassUtils.getPrimitiveType((String)type.getName()).orElse(null);
            if (typeClass != null) {
                if (type.isArray()) {
                    Type arrayType = Type.getType(Array.newInstance(typeClass, 0).getClass());
                    methodVisitor.push(arrayType);
                } else {
                    Type wrapperType = Type.getType((Class)ReflectionUtils.getWrapperType((Class)typeClass));
                    methodVisitor.visitFieldInsn(178, wrapperType.getInternalName(), "TYPE", Type.getDescriptor(Class.class));
                }
            } else {
                methodVisitor.push(JavaModelUtils.getTypeReference(type));
            }
        } else {
            methodVisitor.push(JavaModelUtils.getTypeReference(type));
        }
        methodVisitor.arrayStore(TYPE_CLASS);
        if (index < size - 1) {
            methodVisitor.dup();
        }
    }

    protected Type[] getTypes(Collection<ClassElement> types) {
        Type[] converted = new Type[types.size()];
        Iterator<ClassElement> iter = types.iterator();
        for (int i = 0; i < converted.length; ++i) {
            ClassElement type = iter.next();
            converted[i] = JavaModelUtils.getTypeReference(type);
        }
        return converted;
    }

    protected static Type getObjectType(Object type) {
        if (type instanceof TypedElement) {
            String name = ((TypedElement)type).getType().getName();
            String internalName = AbstractClassFileWriter.getTypeDescriptor(name);
            return Type.getType((String)internalName);
        }
        if (type instanceof Class) {
            return Type.getType((Class)((Class)type));
        }
        if (type instanceof String) {
            String className = type.toString();
            String internalName = AbstractClassFileWriter.getTypeDescriptor(className);
            return Type.getType((String)internalName);
        }
        throw new IllegalArgumentException("Type reference [" + type + "] should be a Class or a String representing the class name");
    }

    protected static String getTypeDescriptor(String className, String ... genericTypes) {
        if (JavaModelUtils.NAME_TO_TYPE_MAP.containsKey(className)) {
            return JavaModelUtils.NAME_TO_TYPE_MAP.get(className);
        }
        String internalName = AbstractClassFileWriter.getInternalName(className);
        StringBuilder start = new StringBuilder(40);
        Matcher matcher = ARRAY_PATTERN.matcher(className);
        if (matcher.find()) {
            int dimensions = matcher.group(0).length() / 2;
            for (int i = 0; i < dimensions; ++i) {
                start.append('[');
            }
        }
        start.append('L').append(internalName);
        if (genericTypes != null && genericTypes.length > 0) {
            start.append('<');
            for (String genericType : genericTypes) {
                start.append(AbstractClassFileWriter.getTypeDescriptor(genericType));
            }
            start.append('>');
        }
        return start.append(';').toString();
    }

    protected static String getMethodDescriptor(String returnType, String ... argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (String argumentType : argumentTypes) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(argumentType));
        }
        builder.append(')');
        builder.append(AbstractClassFileWriter.getTypeDescriptor(returnType));
        return builder.toString();
    }

    protected static String getMethodDescriptor(TypedElement returnType, Collection<? extends TypedElement> argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (TypedElement typedElement : argumentTypes) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(typedElement));
        }
        builder.append(')');
        builder.append(AbstractClassFileWriter.getTypeDescriptor(returnType));
        return builder.toString();
    }

    protected static String getMethodDescriptorForReturnType(Type returnType, Collection<? extends TypedElement> argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (TypedElement typedElement : argumentTypes) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(typedElement));
        }
        builder.append(')');
        builder.append(returnType.getDescriptor());
        return builder.toString();
    }

    protected static String getMethodDescriptor(Class<?> returnType, Collection<Class<?>> argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Class<?> argumentType : argumentTypes) {
            builder.append(Type.getDescriptor(argumentType));
        }
        builder.append(')');
        builder.append(Type.getDescriptor(returnType));
        return builder.toString();
    }

    protected static String getMethodDescriptor(Type returnType, Collection<Type> argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Type argumentType : argumentTypes) {
            builder.append(argumentType.getDescriptor());
        }
        builder.append(')');
        builder.append(returnType.getDescriptor());
        return builder.toString();
    }

    protected static String getMethodSignature(String returnTypeReference, String ... argReferenceTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (String argumentType : argReferenceTypes) {
            builder.append(argumentType);
        }
        builder.append(')');
        builder.append(returnTypeReference);
        return builder.toString();
    }

    protected static String getConstructorDescriptor(Class<?> ... argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Class<?> argumentType : argumentTypes) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(argumentType));
        }
        return builder.append(")V").toString();
    }

    protected static String getConstructorDescriptor(Type[] argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Type argumentType : argumentTypes) {
            builder.append(argumentType.getDescriptor());
        }
        return builder.append(")V").toString();
    }

    protected static String getConstructorDescriptor(Collection<ParameterElement> argList) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (ParameterElement argumentType : argList) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(argumentType));
        }
        return builder.append(")V").toString();
    }

    protected void writeClassToDisk(File targetDir, ClassWriter classWriter, String className) throws IOException {
        if (targetDir != null) {
            String fileName = className.replace('.', '/') + ".class";
            File targetFile = new File(targetDir, fileName);
            targetFile.getParentFile().mkdirs();
            try (OutputStream outputStream = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);){
                this.writeClassToDisk(outputStream, classWriter);
            }
        }
    }

    protected void writeClassToDisk(OutputStream out, ClassWriter classWriter) throws IOException {
        byte[] bytes = classWriter.toByteArray();
        out.write(bytes);
    }

    protected GeneratorAdapter startConstructor(ClassVisitor classWriter) {
        MethodVisitor defaultConstructor = classWriter.visitMethod(1, CONSTRUCTOR_NAME, DESCRIPTOR_DEFAULT_CONSTRUCTOR, null, null);
        return new GeneratorAdapter(defaultConstructor, 1, CONSTRUCTOR_NAME, DESCRIPTOR_DEFAULT_CONSTRUCTOR);
    }

    protected GeneratorAdapter startConstructor(ClassVisitor classWriter, Class<?> ... argumentTypes) {
        String descriptor = AbstractClassFileWriter.getConstructorDescriptor(argumentTypes);
        return new GeneratorAdapter(classWriter.visitMethod(1, CONSTRUCTOR_NAME, descriptor, null, null), 1, CONSTRUCTOR_NAME, descriptor);
    }

    protected void startClass(ClassVisitor classWriter, String className, Type superType) {
        classWriter.visit(61, 4096, className, null, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void startPublicClass(ClassVisitor classWriter, String className, Type superType) {
        classWriter.visit(61, 4097, className, null, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void startService(ClassVisitor classWriter, Class<?> serviceType, String internalClassName, Type superType) {
        this.startService(classWriter, serviceType.getName(), internalClassName, superType, new String[0]);
    }

    protected void startService(ClassVisitor classWriter, String serviceName, String internalClassName, Type superType, String ... interfaces) {
        classWriter.visit(61, 4113, internalClassName, null, superType.getInternalName(), interfaces);
        AnnotationVisitor annotationVisitor = classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
        annotationVisitor.visit("service", (Object)serviceName);
        annotationVisitor.visitEnd();
    }

    protected void startFinalClass(ClassVisitor classWriter, String className, Type superType) {
        classWriter.visit(61, 4112, className, null, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void startPublicFinalClass(ClassVisitor classWriter, String className, Type superType) {
        classWriter.visit(61, 4113, className, null, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void startClass(ClassWriter classWriter, String className, Type superType, String genericSignature) {
        classWriter.visit(61, 4096, className, genericSignature, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void invokeConstructor(MethodVisitor cv, Class<?> superClass, Class<?> ... argumentTypes) {
        try {
            Type superType = Type.getType(superClass);
            Type superConstructor = Type.getType(superClass.getDeclaredConstructor(argumentTypes));
            cv.visitMethodInsn(183, superType.getInternalName(), CONSTRUCTOR_NAME, superConstructor.getDescriptor(), false);
        }
        catch (NoSuchMethodException e) {
            throw new ClassGenerationException("Micronaut version on compile classpath doesn't match", e);
        }
    }

    protected static void invokeInterfaceStaticMethod(MethodVisitor visitor, Class<?> targetType, Method method) {
        Type type = Type.getType(targetType);
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        visitor.visitMethodInsn(184, owner, method.getName(), method.getDescriptor(), true);
    }

    protected GeneratorAdapter startPublicMethodZeroArgs(ClassWriter classWriter, Class<?> returnType, String methodName) {
        Type methodType = Type.getMethodType((Type)Type.getType(returnType), (Type[])new Type[0]);
        return new GeneratorAdapter(classWriter.visitMethod(1, methodName, methodType.getDescriptor(), null, null), 1, methodName, methodType.getDescriptor());
    }

    protected GeneratorAdapter startPublicFinalMethodZeroArgs(ClassWriter classWriter, Class<?> returnType, String methodName) {
        Type methodType = Type.getMethodType((Type)Type.getType(returnType), (Type[])new Type[0]);
        return new GeneratorAdapter(classWriter.visitMethod(17, methodName, methodType.getDescriptor(), null, null), 1, methodName, methodType.getDescriptor());
    }

    protected static String getInternalName(String className) {
        String newClassName = className.replace('.', '/');
        Matcher matcher = ARRAY_PATTERN.matcher(newClassName);
        if (matcher.find()) {
            newClassName = matcher.replaceFirst("");
        }
        return newClassName;
    }

    protected static String getInternalNameForCast(TypedElement type) {
        ClassElement ce = type.getType();
        if (ce.isPrimitive() && !ce.isArray()) {
            Optional pt = ClassUtils.getPrimitiveType((String)ce.getName());
            if (pt.isPresent()) {
                return Type.getInternalName((Class)ReflectionUtils.getWrapperType((Class)((Class)pt.get())));
            }
            return JavaModelUtils.getTypeReference(ce).getInternalName();
        }
        return JavaModelUtils.getTypeReference(ce).getInternalName();
    }

    protected static String getInternalNameForCast(Class<?> typeClass) {
        if (typeClass.isPrimitive()) {
            typeClass = ReflectionUtils.getWrapperType(typeClass);
        }
        return Type.getInternalName(typeClass);
    }

    protected static String getInternalNameForCast(Type type) {
        Optional pt = ClassUtils.getPrimitiveType((String)type.getClassName());
        if (pt.isPresent()) {
            return Type.getInternalName((Class)ReflectionUtils.getWrapperType((Class)((Class)pt.get())));
        }
        return type.getInternalName();
    }

    protected String getClassFileName(String className) {
        return className.replace('.', File.separatorChar) + ".class";
    }

    protected ClassWriterOutputVisitor newClassWriterOutputVisitor(File compilationDir) {
        return new DirectoryClassWriterOutputVisitor(compilationDir);
    }

    protected void returnVoid(GeneratorAdapter overriddenMethodGenerator) {
        overriddenMethodGenerator.pop();
        overriddenMethodGenerator.visitInsn(177);
    }

    protected GeneratorAdapter visitStaticInitializer(ClassVisitor classWriter) {
        MethodVisitor mv = classWriter.visitMethod(8, "<clinit>", DESCRIPTOR_DEFAULT_CONSTRUCTOR, null, null);
        return new GeneratorAdapter(mv, 8, "<clinit>", DESCRIPTOR_DEFAULT_CONSTRUCTOR);
    }

    protected GeneratorAdapter startPublicMethod(ClassWriter writer, String methodName, String returnType, String ... argumentTypes) {
        return new GeneratorAdapter(writer.visitMethod(1, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes), null, null), 1, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes));
    }

    protected GeneratorAdapter startPublicMethod(ClassWriter writer, Method asmMethod) {
        String methodName = asmMethod.getName();
        return new GeneratorAdapter(writer.visitMethod(1, methodName, asmMethod.getDescriptor(), null, null), 1, methodName, asmMethod.getDescriptor());
    }

    protected GeneratorAdapter startProtectedMethod(ClassWriter writer, String methodName, String returnType, String ... argumentTypes) {
        return new GeneratorAdapter(writer.visitMethod(4, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes), null, null), 4, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes));
    }

    protected void generateServiceDescriptor(String className, GeneratedFile generatedFile) throws IOException {
        CharSequence contents = generatedFile.getTextContent();
        if (contents != null) {
            String[] entries = contents.toString().split("\\n");
            if (!Arrays.asList(entries).contains(className)) {
                try (BufferedWriter w = new BufferedWriter(generatedFile.openWriter());){
                    w.newLine();
                    w.write(className);
                }
            }
        } else {
            try (BufferedWriter w = new BufferedWriter(generatedFile.openWriter());){
                w.write(className);
            }
        }
    }

    protected void pushNewInstance(GeneratorAdapter generatorAdapter, Type typeToInstantiate) {
        generatorAdapter.newInstance(typeToInstantiate);
        generatorAdapter.dup();
        generatorAdapter.invokeConstructor(typeToInstantiate, METHOD_DEFAULT_CONSTRUCTOR);
    }

    @NonNull
    protected ClassElement invokeMethod(@NonNull GeneratorAdapter generatorAdapter, @NonNull MethodElement method) {
        ClassElement returnType = method.getReturnType();
        Method targetMethod = new Method(method.getName(), AbstractClassFileWriter.getMethodDescriptor(returnType, Arrays.asList(method.getParameters())));
        ClassElement declaringElement = method.getDeclaringType();
        Type declaringType = JavaModelUtils.getTypeReference(declaringElement);
        if (method.isStatic()) {
            generatorAdapter.invokeStatic(declaringType, targetMethod);
        } else if (declaringElement.isInterface()) {
            generatorAdapter.invokeInterface(declaringType, targetMethod);
        } else {
            generatorAdapter.invokeVirtual(declaringType, targetMethod);
        }
        return returnType;
    }

    public static <T> void pushStringMapOf(GeneratorAdapter generatorAdapter, Map<? extends CharSequence, T> annotationData, boolean skipEmpty, T empty, Consumer<T> pushValue) {
        Set entrySet;
        Set set = entrySet = annotationData != null ? (Set)annotationData.entrySet().stream().filter(e -> !skipEmpty || e.getKey() != null && AnnotationMetadataWriter.isSupportedMapValue(e.getValue())).map(e -> e.getValue() == null && empty != null ? new AbstractMap.SimpleEntry<String, Object>(((CharSequence)e.getKey()).toString(), empty) : new AbstractMap.SimpleEntry(((CharSequence)e.getKey()).toString(), e.getValue())).collect(Collectors.toCollection(() -> new TreeSet(Map.Entry.comparingByKey()))) : null;
        if (entrySet == null || entrySet.isEmpty()) {
            AbstractClassFileWriter.invokeInterfaceStatic(generatorAdapter, MAP_TYPE, MAP_OF[0]);
            return;
        }
        if (entrySet.size() < MAP_OF.length) {
            for (Map.Entry entry : entrySet) {
                generatorAdapter.push((String)entry.getKey());
                pushValue.accept(entry.getValue());
            }
            AbstractClassFileWriter.invokeInterfaceStatic(generatorAdapter, MAP_TYPE, MAP_OF[entrySet.size()]);
        } else {
            int totalSize = entrySet.size();
            AbstractClassFileWriter.pushNewArray(generatorAdapter, Map.Entry.class, totalSize);
            int i = 0;
            for (Map.Entry entry : entrySet) {
                AbstractClassFileWriter.pushStoreInArray(generatorAdapter, i++, totalSize, () -> {
                    generatorAdapter.push(((CharSequence)entry.getKey()).toString());
                    pushValue.accept(entry.getValue());
                    AbstractClassFileWriter.invokeInterfaceStatic(generatorAdapter, MAP_TYPE, MAP_ENTRY);
                });
            }
            AbstractClassFileWriter.invokeInterfaceStatic(generatorAdapter, MAP_TYPE, MAP_BY_ARRAY);
        }
    }

    public static void pushListOfString(GeneratorAdapter methodVisitor, List<String> names) {
        if (names != null) {
            names = names.stream().filter(Objects::nonNull).toList();
        }
        if (names == null || names.isEmpty()) {
            AbstractClassFileWriter.invokeInterfaceStatic(methodVisitor, LIST_TYPE, LIST_OF[0]);
            return;
        }
        if (names.size() < LIST_OF.length) {
            for (String name : names) {
                methodVisitor.push(name);
            }
            AbstractClassFileWriter.invokeInterfaceStatic(methodVisitor, LIST_TYPE, LIST_OF[names.size()]);
        } else {
            int totalSize = names.size();
            AbstractClassFileWriter.pushNewArray(methodVisitor, String.class, totalSize);
            int i = 0;
            for (String name : names) {
                AbstractClassFileWriter.pushStoreStringInArray(methodVisitor, i++, totalSize, name);
            }
            AbstractClassFileWriter.invokeInterfaceStatic(methodVisitor, LIST_TYPE, LIST_BY_ARRAY);
        }
    }

    private static void invokeInterfaceStatic(GeneratorAdapter methodVisitor, Type type, Method method) {
        methodVisitor.visitMethodInsn(184, type.getInternalName(), method.getName(), method.getDescriptor(), true);
    }

    static {
        int k;
        int i;
        TYPE_ARGUMENT = Type.getType(Argument.class);
        TYPE_ARGUMENT_ARRAY = Type.getType(Argument[].class);
        METHOD_DEFAULT_CONSTRUCTOR = new Method(CONSTRUCTOR_NAME, DESCRIPTOR_DEFAULT_CONSTRUCTOR);
        TYPE_OBJECT = Type.getType(Object.class);
        TYPE_CLASS = Type.getType(Class.class);
        TYPE_GENERATED = Type.getType(Generated.class);
        ARRAY_PATTERN = Pattern.compile("(\\[\\])+$");
        METHOD_CREATE_ARGUMENT_SIMPLE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"of", (Class[])new Class[]{Class.class, String.class}));
        METHOD_GENERIC_PLACEHOLDER_SIMPLE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"ofTypeVariable", (Class[])new Class[]{Class.class, String.class, String.class}));
        METHOD_CREATE_TYPE_VARIABLE_SIMPLE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"ofTypeVariable", (Class[])new Class[]{Class.class, String.class}));
        METHOD_CREATE_ARGUMENT_WITH_ANNOTATION_METADATA_GENERICS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"of", (Class[])new Class[]{Class.class, String.class, AnnotationMetadata.class, Argument[].class}));
        METHOD_CREATE_TYPE_VAR_WITH_ANNOTATION_METADATA_GENERICS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"ofTypeVariable", (Class[])new Class[]{Class.class, String.class, AnnotationMetadata.class, Argument[].class}));
        METHOD_CREATE_GENERIC_PLACEHOLDER_WITH_ANNOTATION_METADATA_GENERICS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"ofTypeVariable", (Class[])new Class[]{Class.class, String.class, String.class, AnnotationMetadata.class, Argument[].class}));
        METHOD_CREATE_ARGUMENT_WITH_ANNOTATION_METADATA_CLASS_GENERICS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"of", (Class[])new Class[]{Class.class, AnnotationMetadata.class, Class[].class}));
        MAP_TYPE = Type.getType(Map.class);
        LIST_TYPE = Type.getType(List.class);
        MAP_OF = new Method[11];
        for (i = 0; i < MAP_OF.length; ++i) {
            Class[] mapArgs = new Class[i * 2];
            for (k = 0; k < i * 2; k += 2) {
                mapArgs[k] = Object.class;
                mapArgs[k + 1] = Object.class;
            }
            AbstractClassFileWriter.MAP_OF[i] = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Map.class, (String)"of", (Class[])mapArgs));
        }
        MAP_ENTRY = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Map.class, (String)"entry", (Class[])new Class[]{Object.class, Object.class}));
        MAP_BY_ARRAY = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Map.class, (String)"ofEntries", (Class[])new Class[]{Map.Entry[].class}));
        LIST_OF = new Method[11];
        for (i = 0; i < LIST_OF.length; ++i) {
            Class[] listArgs = new Class[i];
            for (k = 0; k < i; ++k) {
                listArgs[k] = Object.class;
            }
            AbstractClassFileWriter.LIST_OF[i] = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(List.class, (String)"of", (Class[])listArgs));
        }
        LIST_BY_ARRAY = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(List.class, (String)"of", (Class[])new Class[]{Object[].class}));
    }
}

