/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.visitor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.expressions.context.ExpressionCompilationContextFactory;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementFactory;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.visitor.VisitorConfiguration;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public interface VisitorContext
extends MutableConvertibleValues<Object>,
ClassWriterOutputVisitor {
    public static final String MICRONAUT_BASE_OPTION_NAME = "micronaut";
    public static final String MICRONAUT_PROCESSING_PROJECT_DIR = "micronaut.processing.project.dir";
    public static final String MICRONAUT_PROCESSING_GROUP = "micronaut.processing.group";
    public static final String MICRONAUT_PROCESSING_MODULE = "micronaut.processing.module";

    @NonNull
    public ElementFactory<?, ?, ?, ?> getElementFactory();

    @NonNull
    public ElementAnnotationMetadataFactory getElementAnnotationMetadataFactory();

    @NonNull
    public ExpressionCompilationContextFactory getExpressionCompilationContextFactory();

    @Internal
    @NonNull
    public AbstractAnnotationMetadataBuilder<?, ?> getAnnotationMetadataBuilder();

    public void info(String var1, @Nullable Element var2);

    public void info(String var1);

    public void fail(String var1, @Nullable Element var2);

    public void warn(String var1, @Nullable Element var2);

    @NonNull
    default public VisitorConfiguration getConfiguration() {
        return VisitorConfiguration.DEFAULT;
    }

    @Override
    public Optional<GeneratedFile> visitMetaInfFile(String var1, Element ... var2);

    @Override
    public Optional<GeneratedFile> visitGeneratedFile(String var1);

    @NonNull
    default public Iterable<URL> getClasspathResources(@NonNull String path) {
        return Collections.emptyList();
    }

    default public Optional<Path> getProjectDir() {
        URI uri;
        Optional<Path> projectDir = this.get(MICRONAUT_PROCESSING_PROJECT_DIR, Path.class);
        if (projectDir.isPresent()) {
            return projectDir;
        }
        Optional<GeneratedFile> dummyFile = this.visitGeneratedFile("dummy" + System.nanoTime());
        if (dummyFile.isPresent() && (uri = dummyFile.get().toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            for (Path dummy = Paths.get(uri).normalize(); dummy != null; dummy = dummy.getParent()) {
                Path dummyFileName = dummy.getFileName();
                if (dummyFileName == null || !"build".equals(dummyFileName.toString()) && !"target".equals(dummyFileName.toString())) continue;
                projectDir = Optional.ofNullable(dummy.getParent());
                this.put(MICRONAUT_PROCESSING_PROJECT_DIR, dummy.getParent());
                break;
            }
        }
        return projectDir;
    }

    default public Optional<Path> getClassesOutputPath() {
        Optional<GeneratedFile> dummy = this.visitMetaInfFile("dummy", Element.EMPTY_ELEMENT_ARRAY);
        if (dummy.isPresent()) {
            Path classesOutputDir = Paths.get(dummy.get().toURI()).getParent().getParent();
            return Optional.of(classesOutputDir);
        }
        return Optional.empty();
    }

    default public Optional<ClassElement> getClassElement(String name) {
        return Optional.empty();
    }

    default public Optional<ClassElement> getClassElement(String name, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        return Optional.empty();
    }

    default public ClassElement getRequiredClassElement(String name, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        return this.getClassElement(name, annotationMetadataFactory).orElseThrow(() -> new IllegalStateException("Unknown type: " + name));
    }

    default public Optional<ClassElement> getClassElement(Class<?> type) {
        if (type != null) {
            return this.getClassElement(type.getName());
        }
        return Optional.empty();
    }

    @NonNull
    default public ClassElement[] getClassElements(@NonNull String aPackage, String ... stereotypes) {
        return new ClassElement[0];
    }

    default public Map<String, String> getOptions() {
        return Collections.emptyMap();
    }

    default public Collection<String> getGeneratedResources() {
        this.info("EXPERIMENTAL: Compile time resource contribution to the context is experimental", null);
        return Collections.emptyList();
    }

    default public void addGeneratedResource(String resource) {
        this.info("EXPERIMENTAL: Compile time resource contribution to the context is experimental", null);
    }
}

