/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.objectweb.asm.Type;

public class JavaModelUtils {
    public static final Map<String, String> NAME_TO_TYPE_MAP = new HashMap<String, String>();
    private static final ElementKind RECORD_KIND = ReflectionUtils.findDeclaredField(ElementKind.class, (String)"RECORD").flatMap(field -> {
        try {
            return Optional.of((ElementKind)((Object)((Object)field.get(ElementKind.class))));
        }
        catch (IllegalAccessException e) {
            return Optional.empty();
        }
    }).orElse(null);
    private static final ElementKind RECORD_COMPONENT_KIND = ReflectionUtils.findDeclaredField(ElementKind.class, (String)"RECORD_COMPONENT").flatMap(field -> {
        try {
            return Optional.of((ElementKind)((Object)((Object)field.get(ElementKind.class))));
        }
        catch (IllegalAccessException e) {
            return Optional.empty();
        }
    }).orElse(null);

    public static Optional<ElementKind> resolveKind(Element element) {
        if (element != null) {
            try {
                ElementKind kind = element.getKind();
                return Optional.of(kind);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<ElementKind> resolveKind(Element element, ElementKind expected) {
        Optional<ElementKind> elementKind = JavaModelUtils.resolveKind(element);
        if (elementKind.isPresent() && elementKind.get() == expected) {
            return elementKind;
        }
        return Optional.empty();
    }

    public static boolean isInterface(Element element) {
        return JavaModelUtils.resolveKind(element, ElementKind.INTERFACE).isPresent();
    }

    public static boolean isRecord(Element element) {
        return JavaModelUtils.resolveKind(element, RECORD_KIND).isPresent();
    }

    public static boolean isClass(Element element) {
        return JavaModelUtils.resolveKind(element, ElementKind.CLASS).isPresent();
    }

    public static boolean isEnum(Element element) {
        return JavaModelUtils.resolveKind(element, ElementKind.ENUM).isPresent();
    }

    public static boolean isClassOrInterface(Element element) {
        return JavaModelUtils.isInterface(element) || JavaModelUtils.isClass(element);
    }

    public static String getClassName(TypeElement typeElement) {
        Name qualifiedName = typeElement.getQualifiedName();
        try {
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.MEMBER) {
                TypeElement enclosingElement = typeElement;
                StringBuilder builder = new StringBuilder();
                while (nestingKind == NestingKind.MEMBER) {
                    builder.insert(0, '$').insert(1, enclosingElement.getSimpleName());
                    Element enclosing = enclosingElement.getEnclosingElement();
                    if (!(enclosing instanceof TypeElement)) break;
                    enclosingElement = (TypeElement)enclosing;
                    nestingKind = enclosingElement.getNestingKind();
                }
                Name enclosingName = enclosingElement.getQualifiedName();
                return enclosingName.toString() + builder;
            }
            return qualifiedName.toString();
        }
        catch (RuntimeException e) {
            return qualifiedName.toString();
        }
    }

    public static String getClassNameWithoutPackage(TypeElement typeElement) {
        try {
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.MEMBER) {
                TypeElement enclosingElement = typeElement;
                StringBuilder builder = new StringBuilder();
                while (nestingKind == NestingKind.MEMBER) {
                    builder.insert(0, '$').insert(1, enclosingElement.getSimpleName());
                    Element enclosing = enclosingElement.getEnclosingElement();
                    if (!(enclosing instanceof TypeElement)) break;
                    enclosingElement = (TypeElement)enclosing;
                    nestingKind = enclosingElement.getNestingKind();
                }
                Name enclosingName = enclosingElement.getSimpleName();
                return enclosingName.toString() + builder;
            }
            return typeElement.getSimpleName().toString();
        }
        catch (RuntimeException e) {
            return typeElement.getSimpleName().toString();
        }
    }

    public static String getPackageName(TypeElement typeElement) {
        Element enclosingElement;
        for (enclosingElement = typeElement.getEnclosingElement(); enclosingElement != null && enclosingElement.getKind() != ElementKind.PACKAGE; enclosingElement = enclosingElement.getEnclosingElement()) {
        }
        if (enclosingElement == null) {
            return "";
        }
        if (enclosingElement instanceof PackageElement) {
            return ((PackageElement)enclosingElement).getQualifiedName().toString();
        }
        return enclosingElement.toString();
    }

    public static String getClassArrayName(TypeElement typeElement) {
        return "[L" + JavaModelUtils.getClassName(typeElement) + ";";
    }

    public static boolean isRecordOrRecordComponent(Element e) {
        return JavaModelUtils.isRecord(e) || JavaModelUtils.isRecordComponent(e);
    }

    public static boolean isRecordComponent(Element e) {
        return JavaModelUtils.resolveKind(e, RECORD_COMPONENT_KIND).isPresent();
    }

    public static Type getTypeReference(TypedElement type) {
        ClassElement classElement = type.getType();
        if (classElement.isPrimitive()) {
            String internalName = classElement.isVoid() ? NAME_TO_TYPE_MAP.get("void") : NAME_TO_TYPE_MAP.get(classElement.getName());
            if (internalName == null) {
                throw new IllegalStateException("Unrecognized primitive type: " + classElement.getName());
            }
            if (classElement.isArray()) {
                StringBuilder name = new StringBuilder(internalName);
                for (int i = 0; i < classElement.getArrayDimensions(); ++i) {
                    name.insert(0, "[");
                }
                return Type.getObjectType((String)name.toString());
            }
            return Type.getType((String)internalName);
        }
        Object nativeType = classElement.getNativeType();
        if (nativeType instanceof Class) {
            Class t = (Class)nativeType;
            return Type.getType((Class)t);
        }
        String internalName = classElement.getName().replace('.', '/');
        if (internalName.isEmpty()) {
            return Type.getType(Object.class);
        }
        if (classElement.isArray()) {
            StringBuilder name = new StringBuilder(internalName);
            name.insert(0, "L");
            for (int i = 0; i < classElement.getArrayDimensions(); ++i) {
                name.insert(0, "[");
            }
            name.append(";");
            return Type.getObjectType((String)name.toString());
        }
        return Type.getObjectType((String)internalName);
    }

    public static String getClassname(TypedElement type) {
        return JavaModelUtils.getTypeReference(type).getClassName();
    }

    static {
        NAME_TO_TYPE_MAP.put("void", "V");
        NAME_TO_TYPE_MAP.put("boolean", "Z");
        NAME_TO_TYPE_MAP.put("char", "C");
        NAME_TO_TYPE_MAP.put("int", "I");
        NAME_TO_TYPE_MAP.put("byte", "B");
        NAME_TO_TYPE_MAP.put("long", "J");
        NAME_TO_TYPE_MAP.put("double", "D");
        NAME_TO_TYPE_MAP.put("float", "F");
        NAME_TO_TYPE_MAP.put("short", "S");
    }
}

