/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.processing.AbstractBeanElementCreator;
import io.micronaut.inject.processing.ConfigurationReaderBeanElementCreator;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Internal
final class IntroductionInterfaceBeanElementCreator
extends AbstractBeanElementCreator {
    IntroductionInterfaceBeanElementCreator(ClassElement classElement, VisitorContext visitorContext) {
        super(classElement, visitorContext);
    }

    @Override
    public void buildInternal() {
        MethodElement constructorElement;
        AopProxyWriter aopProxyWriter = this.createIntroductionAopProxyWriter(this.classElement, this.visitorContext);
        aopProxyWriter.visitTypeArguments(this.classElement.getAllTypeArguments());
        if (this.classElement.hasAnnotation(ANN_REQUIRES_VALIDATION)) {
            if (ConfigurationReaderBeanElementCreator.isConfigurationProperties(this.classElement)) {
                aopProxyWriter.setValidated(true);
            } else {
                for (MethodElement methodElement : this.classElement.getEnclosedElements(ElementQuery.ALL_METHODS.annotated(am -> am.hasAnnotation(ANN_REQUIRES_VALIDATION)))) {
                    methodElement.annotate("io.micronaut.validation.Validated");
                }
            }
        }
        if ((constructorElement = (MethodElement)this.classElement.getPrimaryConstructor().orElse(null)) != null) {
            aopProxyWriter.visitBeanDefinitionConstructor(constructorElement, constructorElement.isReflectionRequired(), this.visitorContext);
        } else {
            aopProxyWriter.visitDefaultConstructor((AnnotationMetadata)this.classElement, this.visitorContext);
        }
        ArrayList<MethodElement> allMethods = new ArrayList<MethodElement>(this.classElement.getEnclosedElements(ElementQuery.ALL_METHODS.includeOverriddenMethods()));
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>(allMethods);
        List<MethodElement> nonAbstractMethods = methods.stream().filter(m -> !m.isAbstract()).toList();
        methods.removeIf(method -> method.isAbstract() && nonAbstractMethods.stream().anyMatch(nonAbstractMethod -> nonAbstractMethod.overrides((MethodElement)method)));
        methods.removeIf(method -> !method.isAbstract() && !InterceptedMethodUtil.hasDeclaredAroundAdvice((AnnotationMetadata)method.getAnnotationMetadata()));
        Collections.reverse(methods);
        for (MethodElement methodElement : methods) {
            this.visitIntrospectedMethod(aopProxyWriter, this.classElement, methodElement);
        }
        List<PropertyElement> beanProperties = this.classElement.getSyntheticBeanProperties();
        for (PropertyElement beanProperty : beanProperties) {
            this.handlePropertyMethod(aopProxyWriter, methods, beanProperty.getReadMethod().orElse(null));
            this.handlePropertyMethod(aopProxyWriter, methods, beanProperty.getWriteMethod().orElse(null));
        }
        this.beanDefinitionWriters.add(aopProxyWriter);
    }

    private void handlePropertyMethod(BeanDefinitionVisitor aopProxyWriter, List<MethodElement> methods, MethodElement method) {
        if (method != null && method.isAbstract() && !methods.contains(method)) {
            this.visitIntrospectedMethod(aopProxyWriter, this.classElement, method);
        }
    }
}

