/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.visitor.ConfigurationReaderVisitor;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.PropertyElementQuery;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.processing.DeclaredBeanElementCreator;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Internal
final class ConfigurationReaderBeanElementCreator
extends DeclaredBeanElementCreator {
    private static final List<String> CONSTRUCTOR_PARAMETERS_INJECTION_ANN = Arrays.asList(Property.class.getName(), Value.class.getName(), Parameter.class.getName(), "jakarta.inject.Qualifier", "jakarta.inject.Inject");
    private final ConfigurationMetadataBuilder metadataBuilder = ConfigurationMetadataBuilder.INSTANCE;

    ConfigurationReaderBeanElementCreator(ClassElement classElement, VisitorContext visitorContext) {
        super(classElement, visitorContext, false);
    }

    @Override
    protected void applyConfigurationInjectionIfNecessary(BeanDefinitionVisitor visitor, MethodElement constructor) {
        if (!this.classElement.isRecord() && !constructor.hasAnnotation(ConfigurationInject.class)) {
            return;
        }
        if (this.classElement.isRecord()) {
            List<PropertyElement> beanProperties = constructor.getDeclaringType().getBeanProperties();
            ParameterElement[] parameters = constructor.getParameters();
            if (beanProperties.size() == parameters.length) {
                Javadoc javadoc = this.classElement.getDocumentation().map(StaticJavaParser::parseJavadoc).orElse(null);
                for (int i = 0; i < parameters.length; ++i) {
                    ParameterElement parameter = parameters[i];
                    PropertyElement bp = beanProperties.get(i);
                    if (!CONSTRUCTOR_PARAMETERS_INJECTION_ANN.stream().noneMatch(arg_0 -> ((PropertyElement)bp).hasStereotype(arg_0))) continue;
                    String paramDoc = ConfigurationReaderBeanElementCreator.findParameterDoc(javadoc, parameter);
                    this.processConfigurationConstructorParameter(parameter, paramDoc);
                }
                if (constructor.hasStereotype(ANN_REQUIRES_VALIDATION)) {
                    visitor.setValidated(true);
                }
                return;
            }
        }
        this.processConfigurationInjectionPoint(visitor, constructor);
    }

    @Nullable
    private static String findParameterDoc(Javadoc javadoc, ParameterElement parameter) {
        JavadocBlockTag bt;
        String paramDoc = null;
        if (javadoc != null && (bt = (JavadocBlockTag)javadoc.getBlockTags().stream().filter(t -> t.getType() == JavadocBlockTag.Type.PARAM && t.getName().map(n -> n.equals(parameter.getName())).orElse(false) != false).findFirst().orElse(null)) != null) {
            paramDoc = bt.getContent().toText();
        }
        return paramDoc;
    }

    private void processConfigurationInjectionPoint(BeanDefinitionVisitor visitor, MethodElement constructor) {
        Javadoc javadoc = constructor.getDocumentation().map(StaticJavaParser::parseJavadoc).orElse(null);
        for (ParameterElement parameter : constructor.getParameters()) {
            if (!CONSTRUCTOR_PARAMETERS_INJECTION_ANN.stream().noneMatch(arg_0 -> ((ParameterElement)parameter).hasStereotype(arg_0))) continue;
            String paramDoc = ConfigurationReaderBeanElementCreator.findParameterDoc(javadoc, parameter);
            this.processConfigurationConstructorParameter(parameter, paramDoc);
        }
        if (constructor.hasStereotype(ANN_REQUIRES_VALIDATION)) {
            visitor.setValidated(true);
        }
    }

    private void processConfigurationConstructorParameter(ParameterElement parameter, @Nullable String paramDoc) {
        if (ConfigurationReaderVisitor.isPropertyParameter(parameter, this.visitorContext)) {
            PropertyMetadata pm = this.metadataBuilder.visitProperty(parameter.getMethodElement().getOwningType(), parameter.getMethodElement().getDeclaringType(), parameter.getGenericType(), parameter.getName(), paramDoc, parameter.stringValue(Bindable.class, "defaultValue").orElse(null));
            parameter.annotate(Property.class, builder -> builder.member("name", pm.getPath()));
        }
    }

    public static boolean isConfigurationProperties(ClassElement classElement) {
        return classElement.hasStereotype(ConfigurationReader.class);
    }

    @Override
    protected void makeInterceptedForValidationIfNeeded(MethodElement element) {
    }

    @Override
    protected boolean processAsProperties() {
        return true;
    }

    @Override
    protected boolean visitProperty(BeanDefinitionVisitor visitor, PropertyElement propertyElement) {
        Optional<MethodElement> readMethod = propertyElement.getReadMethod();
        Optional<FieldElement> field = propertyElement.getField();
        if (propertyElement.hasStereotype(ConfigurationBuilder.class)) {
            if (readMethod.isPresent()) {
                MethodElement methodElement = readMethod.get();
                ClassElement builderType = methodElement.getReturnType();
                visitor.visitConfigBuilderMethod(builderType, methodElement.getName(), propertyElement.getAnnotationMetadata(), null, builderType.isInterface());
                this.visitConfigurationBuilder(visitor, propertyElement, builderType);
                return true;
            }
            if (field.isPresent()) {
                FieldElement fieldElement = field.get();
                if (fieldElement.isAccessible(this.classElement)) {
                    ClassElement builderType = fieldElement.getType();
                    visitor.visitConfigBuilderField(builderType, fieldElement.getName(), fieldElement.getAnnotationMetadata(), this.metadataBuilder, builderType.isInterface());
                    this.visitConfigurationBuilder(visitor, propertyElement, builderType);
                    return true;
                }
                throw new ProcessingException(fieldElement, "ConfigurationBuilder applied to a non accessible (private or package-private/protected in a different package) field must have a corresponding non-private getter method.");
            }
        } else if (!propertyElement.isExcluded()) {
            MethodElement methodElement;
            boolean claimed = false;
            Optional<MethodElement> writeMethod = propertyElement.getWriteMethod();
            if (propertyElement.getWriteAccessKind() == PropertyElement.AccessKind.METHOD && writeMethod.isPresent()) {
                visitor.setValidated(visitor.isValidated() || propertyElement.hasAnnotation(ANN_REQUIRES_VALIDATION));
                methodElement = writeMethod.get();
                ParameterElement parameter = methodElement.getParameters()[0];
                MutableAnnotationMetadata annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{propertyElement, parameter}).merge();
                MutableAnnotationMetadata finalAnnotationMetadata = annotationMetadata = this.calculatePath(propertyElement, methodElement, (AnnotationMetadata)annotationMetadata);
                methodElement = methodElement.withAnnotationMetadata((AnnotationMetadata)annotationMetadata).withParameters((ParameterElement[])Arrays.stream(methodElement.getParameters()).map(arg_0 -> ConfigurationReaderBeanElementCreator.lambda$visitProperty$3(parameter, (AnnotationMetadata)finalAnnotationMetadata, arg_0)).toArray(ParameterElement[]::new));
                visitor.visitSetterValue(methodElement.getDeclaringType(), methodElement, (AnnotationMetadata)annotationMetadata, methodElement.isReflectionRequired(this.classElement), true);
                claimed = true;
            } else if (propertyElement.getWriteAccessKind() == PropertyElement.AccessKind.FIELD && field.isPresent()) {
                visitor.setValidated(visitor.isValidated() || propertyElement.hasAnnotation(ANN_REQUIRES_VALIDATION));
                FieldElement fieldElement = field.get();
                MutableAnnotationMetadata annotationMetadata = MutableAnnotationMetadata.of((AnnotationMetadata)propertyElement.getAnnotationMetadata());
                annotationMetadata = this.calculatePath(propertyElement, fieldElement, (AnnotationMetadata)annotationMetadata);
                visitor.visitFieldValue(fieldElement.getDeclaringType(), fieldElement.withAnnotationMetadata((AnnotationMetadata)annotationMetadata), fieldElement.isReflectionRequired(this.classElement), true);
                claimed = true;
            }
            if (readMethod.isPresent() && (methodElement = readMethod.get()).hasStereotype(Executable.class)) {
                claimed |= this.visitExecutableMethod(visitor, methodElement);
            }
            return claimed;
        }
        return false;
    }

    @Override
    protected boolean visitField(BeanDefinitionVisitor visitor, FieldElement fieldElement) {
        if (fieldElement.hasStereotype(ConfigurationBuilder.class)) {
            if (fieldElement.isAccessible(this.classElement)) {
                ClassElement builderType = fieldElement.getType();
                visitor.visitConfigBuilderField(builderType, fieldElement.getName(), fieldElement.getAnnotationMetadata(), this.metadataBuilder, builderType.isInterface());
                this.visitConfigurationBuilder(visitor, fieldElement, builderType);
                return true;
            }
            throw new ProcessingException(fieldElement, "ConfigurationBuilder applied to a non accessible (private or package-private/protected in a different package) field must have a corresponding non-private getter method.");
        }
        return super.visitField(visitor, fieldElement);
    }

    private AnnotationMetadata calculatePath(PropertyElement propertyElement, MemberElement writeMember, AnnotationMetadata annotationMetadata) {
        String path = this.metadataBuilder.visitProperty(writeMember.getOwningType(), writeMember.getDeclaringType(), propertyElement.getGenericType(), propertyElement.getName(), ConfigurationMetadataBuilder.resolveJavadocDescription(propertyElement), null).getPath();
        return this.visitorContext.getAnnotationMetadataBuilder().annotate(annotationMetadata, AnnotationValue.builder(Property.class).member("name", path).build());
    }

    @Override
    protected boolean isInjectPointMethod(MemberElement memberElement) {
        return super.isInjectPointMethod(memberElement) || memberElement.hasDeclaredStereotype(ConfigurationInject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitConfigurationBuilder(BeanDefinitionVisitor visitor, MemberElement builderElement, ClassElement builderType) {
        try {
            String configurationPrefix = builderElement.stringValue(ConfigurationBuilder.class).map(v -> v + ".").orElse("");
            builderType.getBeanProperties(PropertyElementQuery.of((AnnotationMetadata)builderElement)).stream().filter(propertyElement -> {
                if (propertyElement.isExcluded()) {
                    return false;
                }
                Optional<MethodElement> writeMethod = propertyElement.getWriteMethod();
                if (writeMethod.isEmpty()) {
                    return false;
                }
                MethodElement methodElement = writeMethod.get();
                if (methodElement.hasStereotype(Deprecated.class) || !methodElement.isPublic()) {
                    return false;
                }
                return methodElement.getParameters().length <= 2;
            }).forEach(propertyElement -> {
                MethodElement methodElement = propertyElement.getWriteMethod().get();
                String propertyName = propertyElement.getName();
                ParameterElement[] params = methodElement.getParameters();
                int paramCount = params.length;
                if (paramCount < 2) {
                    ParameterElement parameterElement = paramCount == 1 ? params[0] : null;
                    ClassElement parameterElementType = parameterElement == null ? null : parameterElement.getGenericType();
                    PropertyMetadata metadata = this.metadataBuilder.visitProperty(this.classElement, builderElement.getDeclaringType(), propertyElement.getType(), configurationPrefix + propertyName, null, null);
                    visitor.visitConfigBuilderMethod(propertyName, methodElement.getReturnType(), methodElement.getSimpleName(), parameterElementType, parameterElementType != null ? parameterElementType.getTypeArguments() : null, metadata.getPath());
                } else if (paramCount == 2) {
                    ParameterElement first = params[0];
                    ParameterElement second = params[1];
                    ClassElement firstParamType = first.getType();
                    ClassElement secondParamType = second.getType();
                    if (firstParamType.getSimpleName().equals("long") && secondParamType.isAssignable(TimeUnit.class)) {
                        PropertyMetadata metadata = this.metadataBuilder.visitProperty(this.classElement, methodElement.getDeclaringType(), this.visitorContext.getClassElement(Duration.class.getName()).get(), configurationPrefix + propertyName, null, null);
                        visitor.visitConfigBuilderDurationMethod(propertyName, methodElement.getReturnType(), methodElement.getSimpleName(), metadata.getPath());
                    }
                }
            });
        }
        finally {
            visitor.visitConfigBuilderEnd();
        }
    }

    private static /* synthetic */ ParameterElement lambda$visitProperty$3(ParameterElement parameter, AnnotationMetadata finalAnnotationMetadata, ParameterElement p) {
        return p == parameter ? parameter.withAnnotationMetadata(finalAnnotationMetadata) : p;
    }
}

