/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.configuration;

import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import java.util.Objects;
import java.util.Optional;

@Internal
public final class ConfigurationUtils {
    private static final String EACH_PROPERTY_LIST_SUFFIX = "[*]";
    private static final String EACH_PROPERTY_MAP_SUFFIX = ".*";

    private ConfigurationUtils() {
    }

    public static String buildPropertyPath(ClassElement owningType, ClassElement declaringType, String propertyName) {
        String typePath = declaringType.hasStereotype(ConfigurationReader.class) ? ConfigurationUtils.getRequiredTypePath(declaringType) : ConfigurationUtils.getRequiredTypePath(owningType);
        return typePath + "." + propertyName;
    }

    public static String getRequiredTypePath(ClassElement classElement) {
        return ConfigurationUtils.getTypePath(classElement).orElseThrow(() -> new IllegalStateException("Prefix is required for " + classElement));
    }

    public static Optional<String> getTypePath(ClassElement classElement) {
        if (!classElement.hasStereotype(ConfigurationReader.class)) {
            return Optional.empty();
        }
        if (classElement.isTrue(ConfigurationReader.class, "prefixCalculated")) {
            return classElement.stringValue(ConfigurationReader.class, "prefix");
        }
        String path = ConfigurationUtils.getPath((AnnotationMetadata)classElement);
        path = ConfigurationUtils.prependSuperclasses(classElement, path);
        String finalPath = path = ConfigurationUtils.prependInners(classElement, path);
        classElement.annotate(ConfigurationReader.class, builder -> builder.member("prefix", finalPath).member("prefixCalculated", true));
        return Optional.of(path);
    }

    private static String combinePaths(String p1, String p2) {
        if (StringUtils.isNotEmpty((CharSequence)p1) && StringUtils.isNotEmpty((CharSequence)p2)) {
            return p1 + "." + p2;
        }
        if (StringUtils.isNotEmpty((CharSequence)p1)) {
            return p1;
        }
        return p2;
    }

    private static String getPath(AnnotationMetadata annotationMetadata) {
        Optional basePrefixOptional = annotationMetadata.stringValue(ConfigurationReader.class, "basePrefix");
        Optional prefixOptional = annotationMetadata.stringValue(ConfigurationReader.class, "prefix");
        String prefix = basePrefixOptional.isPresent() ? (prefixOptional.isEmpty() ? (String)basePrefixOptional.get() : (String)prefixOptional.map(p -> (String)basePrefixOptional.get() + "." + p).orElse(null)) : (String)prefixOptional.orElse(null);
        if (annotationMetadata.hasDeclaredAnnotation(EachProperty.class)) {
            return ConfigurationUtils.computeIterablePrefix(annotationMetadata, prefix);
        }
        if (prefix == null) {
            return "";
        }
        return prefix;
    }

    @NonNull
    private static String computeIterablePrefix(AnnotationMetadata annotationMetadata, String prefix) {
        Objects.requireNonNull(prefix);
        if (annotationMetadata.booleanValue(EachProperty.class, "list").orElse(false).booleanValue()) {
            if (!prefix.endsWith(EACH_PROPERTY_LIST_SUFFIX)) {
                return prefix + EACH_PROPERTY_LIST_SUFFIX;
            }
            return prefix;
        }
        if (!prefix.endsWith(EACH_PROPERTY_MAP_SUFFIX)) {
            return prefix + EACH_PROPERTY_MAP_SUFFIX;
        }
        return prefix;
    }

    private static String prependInners(ClassElement classElement, String path) {
        Optional<ClassElement> inner = classElement.getEnclosingType();
        while (classElement.isInner() && inner.isPresent()) {
            String parentPrefix;
            ClassElement enclosingType = inner.get();
            if (enclosingType.isTrue(ConfigurationReader.class, "prefixCalculated")) {
                parentPrefix = enclosingType.stringValue(ConfigurationReader.class, "prefix").orElse("");
                path = ConfigurationUtils.combinePaths(parentPrefix, path);
                break;
            }
            parentPrefix = ConfigurationUtils.getPath((AnnotationMetadata)enclosingType);
            path = ConfigurationUtils.combinePaths(parentPrefix, path);
            path = ConfigurationUtils.prependSuperclasses(enclosingType, path);
            inner = enclosingType.getEnclosingType();
        }
        return path;
    }

    private static String prependSuperclasses(ClassElement declaringType, String path) {
        if (declaringType.isInterface()) {
            path = ConfigurationUtils.prependInterfaces(declaringType, path);
        } else {
            Optional<ClassElement> optionalSuperType = declaringType.getSuperType();
            while (optionalSuperType.isPresent()) {
                ClassElement superType = optionalSuperType.get();
                if (superType.isTrue(ConfigurationReader.class, "prefixCalculated")) {
                    String parentPrefix = superType.stringValue(ConfigurationReader.class, "prefix").orElse("");
                    path = ConfigurationUtils.combinePaths(parentPrefix, path);
                    break;
                }
                String parentConfig = ConfigurationUtils.getPath((AnnotationMetadata)superType);
                if (StringUtils.isNotEmpty((CharSequence)parentConfig)) {
                    path = ConfigurationUtils.combinePaths(parentConfig, path);
                }
                optionalSuperType = superType.getSuperType();
            }
        }
        return path;
    }

    private static String prependInterfaces(ClassElement declaringType, String path) {
        ClassElement superInterface = ConfigurationUtils.resolveSuperInterface(declaringType);
        while (superInterface != null) {
            String parentConfig = ConfigurationUtils.getPath((AnnotationMetadata)superInterface);
            if (StringUtils.isNotEmpty((CharSequence)parentConfig)) {
                path = ConfigurationUtils.combinePaths(parentConfig, path);
            }
            superInterface = ConfigurationUtils.resolveSuperInterface(superInterface);
        }
        return path;
    }

    private static ClassElement resolveSuperInterface(ClassElement declaringType) {
        return declaringType.getInterfaces().stream().filter(tm -> tm.hasStereotype(ConfigurationReader.class)).findFirst().orElse(null);
    }
}

