/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.utils;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

@Internal
public abstract class EnclosedElementsQuery<C, N> {
    private static final int MAX_ITEMS_IN_CACHE = 200;
    private final Map<CacheKey, Element> elementsCache = new LinkedHashMap<CacheKey, Element>();

    protected C getNativeClassType(ClassElement classElement) {
        return (C)classElement.getNativeType();
    }

    protected N getNativeType(Element element) {
        return (N)element.getNativeType();
    }

    public <T extends Element> List<T> getEnclosedElements(ClassElement classElement, @NonNull ElementQuery<T> query) {
        Objects.requireNonNull(query, "Query cannot be null");
        ElementQuery.Result result = query.result();
        Set<N> excludeElements = this.getExcludedNativeElements(result);
        Predicate<Element> filter = element -> {
            if (excludeElements.contains(this.getNativeType((Element)element))) {
                return false;
            }
            List elementPredicates = result.getElementPredicates();
            if (!elementPredicates.isEmpty()) {
                for (Predicate<Element> predicate : elementPredicates) {
                    if (predicate.test((Element)element)) continue;
                    return false;
                }
            }
            if (element instanceof MethodElement) {
                MethodElement methodElement = (MethodElement)element;
                if (result.isOnlyAbstract()) {
                    if (methodElement.getDeclaringType().isInterface() && methodElement.isDefault()) {
                        return false;
                    }
                    if (!element.isAbstract()) {
                        return false;
                    }
                } else if (result.isOnlyConcrete()) {
                    if (methodElement.getDeclaringType().isInterface() && !methodElement.isDefault()) {
                        return false;
                    }
                    if (element.isAbstract()) {
                        return false;
                    }
                }
            }
            if (result.isOnlyInstance() && element.isStatic()) {
                return false;
            }
            if (result.isOnlyStatic() && !element.isStatic()) {
                return false;
            }
            if (result.isOnlyAccessible()) {
                if (element.isPrivate() || element.getName().startsWith("$")) {
                    return false;
                }
                if (element instanceof MemberElement && !((MemberElement)element).isAccessible()) {
                    return false;
                }
            }
            if (!result.getModifierPredicates().isEmpty()) {
                Set<ElementModifier> modifiers = element.getModifiers();
                for (Predicate<Set<ElementModifier>> predicate : result.getModifierPredicates()) {
                    if (predicate.test(modifiers)) continue;
                    return false;
                }
            }
            if (!result.getNamePredicates().isEmpty()) {
                for (Predicate<Object> predicate : result.getNamePredicates()) {
                    if (predicate.test(element.getName())) continue;
                    return false;
                }
            }
            if (!result.getAnnotationPredicates().isEmpty()) {
                for (Predicate<Object> predicate : result.getAnnotationPredicates()) {
                    if (predicate.test(element)) continue;
                    return false;
                }
            }
            if (!result.getTypePredicates().isEmpty()) {
                for (Predicate<Object> predicate : result.getTypePredicates()) {
                    void var8_22;
                    if (element instanceof ConstructorElement) {
                        ClassElement classElement2 = classElement;
                    } else if (element instanceof MethodElement) {
                        MethodElement methodElement = (MethodElement)element;
                        ClassElement classElement3 = methodElement.getGenericReturnType();
                    } else if (element instanceof ClassElement) {
                        ClassElement theClass;
                        ClassElement classElement4 = theClass = (ClassElement)element;
                    } else if (element instanceof FieldElement) {
                        FieldElement fieldElement = (FieldElement)element;
                        ClassElement classElement5 = fieldElement.getGenericField();
                    } else {
                        throw new IllegalStateException("Unknown element: " + element);
                    }
                    if (predicate.test(var8_22)) continue;
                    return false;
                }
            }
            return true;
        };
        Collection<Element> allElements = this.getAllElements(this.getNativeClassType(classElement), result.isOnlyDeclared(), (t1, t2) -> this.reduceElements((Element)t1, (Element)t2, result), result);
        return allElements.stream().filter(filter).toList();
    }

    private boolean reduceElements(Element newElement, Element existingElement, ElementQuery.Result<?> result) {
        MethodElement existingMethodElement;
        MethodElement newMethodElement;
        if (!result.isIncludeHiddenElements()) {
            if (newElement instanceof FieldElement) {
                FieldElement newFiledElement = (FieldElement)newElement;
                if (existingElement instanceof FieldElement) {
                    FieldElement existingFieldElement = (FieldElement)existingElement;
                    return newFiledElement.hides(existingFieldElement);
                }
            }
            if (newElement instanceof MethodElement) {
                newMethodElement = (MethodElement)newElement;
                if (existingElement instanceof MethodElement && newMethodElement.hides(existingMethodElement = (MethodElement)existingElement)) {
                    return true;
                }
            }
        }
        if (!result.isIncludeOverriddenMethods()) {
            if (newElement instanceof MethodElement) {
                newMethodElement = (MethodElement)newElement;
                if (existingElement instanceof MethodElement) {
                    existingMethodElement = (MethodElement)existingElement;
                    return newMethodElement.overrides(existingMethodElement);
                }
            }
            if (newElement instanceof PropertyElement) {
                PropertyElement newPropertyElement = (PropertyElement)newElement;
                if (existingElement instanceof PropertyElement) {
                    PropertyElement existingPropertyElement = (PropertyElement)existingElement;
                    return newPropertyElement.overrides(existingPropertyElement);
                }
            }
        }
        return false;
    }

    private <T extends Element> Collection<T> getAllElements(C classNode, boolean onlyDeclared, BiPredicate<T, T> reduce, ElementQuery.Result<?> result) {
        LinkedHashSet elements = new LinkedHashSet();
        ArrayList<List<N>> hierarchy = new ArrayList<List<N>>();
        this.collectHierarchy(classNode, onlyDeclared, hierarchy, result);
        for (List list : hierarchy) {
            LinkedHashSet<Element> addedFromClassElements = new LinkedHashSet<Element>();
            block1: for (Object element : list) {
                Iterator<Map.Entry<CacheKey, Element>> iterator;
                String elementName = this.getElementName(element);
                for (Predicate<String> namePredicate : result.getNamePredicates()) {
                    if (namePredicate.test(elementName)) continue;
                    continue block1;
                }
                Object nativeType = this.getCacheKey(element);
                CacheKey cacheKey = new CacheKey(result.getElementType(), nativeType);
                Element newElement = this.elementsCache.computeIfAbsent(cacheKey, ck -> this.toAstElement(nativeType, result.getElementType()));
                if (result.getElementType() == MemberElement.class) {
                    if (newElement instanceof FieldElement) {
                        this.elementsCache.putIfAbsent(new CacheKey(FieldElement.class, nativeType), newElement);
                    } else if (newElement instanceof ConstructorElement) {
                        this.elementsCache.putIfAbsent(new CacheKey(ConstructorElement.class, nativeType), newElement);
                        this.elementsCache.putIfAbsent(new CacheKey(MethodElement.class, nativeType), newElement);
                    } else if (newElement instanceof MethodElement) {
                        this.elementsCache.putIfAbsent(new CacheKey(MethodElement.class, nativeType), newElement);
                    } else if (newElement instanceof PropertyElement) {
                        this.elementsCache.putIfAbsent(new CacheKey(PropertyElement.class, nativeType), newElement);
                    }
                } else if (MemberElement.class.isAssignableFrom(result.getElementType())) {
                    this.elementsCache.putIfAbsent(new CacheKey(MemberElement.class, nativeType), newElement);
                }
                if (this.elementsCache.size() == 200) {
                    iterator = this.elementsCache.entrySet().iterator();
                    iterator.next();
                    iterator.remove();
                }
                if (!result.getElementType().isInstance(newElement)) {
                    this.elementsCache.remove(cacheKey);
                    newElement = this.elementsCache.computeIfAbsent(cacheKey, ck -> this.toAstElement(nativeType, result.getElementType()));
                }
                iterator = elements.iterator();
                while (iterator.hasNext()) {
                    Element existingElement = (Element)((Object)iterator.next());
                    if (newElement.equals(existingElement)) continue;
                    if (reduce.test(newElement, existingElement)) {
                        iterator.remove();
                        addedFromClassElements.add(newElement);
                        continue;
                    }
                    if (!reduce.test(existingElement, newElement)) continue;
                    continue block1;
                }
                addedFromClassElements.add(newElement);
            }
            elements.addAll(addedFromClassElements);
        }
        return elements;
    }

    protected abstract String getElementName(N var1);

    protected N getCacheKey(N element) {
        return element;
    }

    private void collectHierarchy(C classNode, boolean onlyDeclared, List<List<N>> hierarchy, ElementQuery.Result<?> result) {
        if (this.excludeClass(classNode)) {
            return;
        }
        if (!onlyDeclared) {
            C superclass = this.getSuperClass(classNode);
            if (superclass != null) {
                this.collectHierarchy(superclass, false, hierarchy, result);
            }
            for (C interfaceNode : this.getInterfaces(classNode)) {
                ArrayList<List<N>> interfaceElements = new ArrayList<List<N>>();
                this.collectHierarchy(interfaceNode, false, interfaceElements, result);
                hierarchy.addAll(interfaceElements);
            }
        }
        hierarchy.add(this.getEnclosedElements(classNode, result));
    }

    protected Set<N> getExcludedNativeElements(@NonNull ElementQuery.Result<?> result) {
        return Collections.emptySet();
    }

    @Nullable
    protected abstract C getSuperClass(C var1);

    @NonNull
    protected abstract Collection<C> getInterfaces(C var1);

    @NonNull
    protected abstract List<N> getEnclosedElements(C var1, ElementQuery.Result<?> var2);

    protected abstract boolean excludeClass(C var1);

    @NonNull
    protected abstract Element toAstElement(N var1, Class<?> var2);

    private record CacheKey(Class<?> elementType, Object nativeType) {
    }
}

