/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.beans;

import io.micronaut.context.annotation.Executable;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.beans.BeanParameterElement;
import java.util.Objects;
import java.util.function.Consumer;

public interface BeanMethodElement
extends MethodElement {
    @NonNull
    default public BeanMethodElement intercept(AnnotationValue<?> ... annotationValue) {
        if (annotationValue != null) {
            for (AnnotationValue<?> value : annotationValue) {
                this.annotate((AnnotationValue)value);
            }
        }
        return this;
    }

    @NonNull
    default public BeanMethodElement executable() {
        this.annotate(Executable.class);
        return this;
    }

    @NonNull
    default public BeanMethodElement executable(boolean processOnStartup) {
        this.annotate(Executable.class, builder -> builder.member("processOnStartup", processOnStartup));
        return this;
    }

    @NonNull
    default public BeanMethodElement inject() {
        if (this.hasAnnotation("jakarta.annotation.PreDestroy")) {
            throw new IllegalStateException("Cannot inject a method annotated with @PreDestroy");
        }
        if (this.hasAnnotation("jakarta.annotation.PostConstruct")) {
            throw new IllegalStateException("Cannot inject a method annotated with @PostConstruct");
        }
        this.annotate("jakarta.inject.Inject");
        return this;
    }

    @NonNull
    default public BeanMethodElement preDestroy() {
        if (this.hasAnnotation("jakarta.inject.Inject")) {
            throw new IllegalStateException("Cannot make a method annotated with @Inject a @PreDestroy handler");
        }
        if (this.hasAnnotation("jakarta.annotation.PostConstruct")) {
            throw new IllegalStateException("Cannot make a method annotated with @PostConstruct a @PreDestroy handler");
        }
        this.annotate("jakarta.annotation.PreDestroy");
        return this;
    }

    @NonNull
    default public BeanMethodElement postConstruct() {
        if (this.hasAnnotation("jakarta.inject.Inject")) {
            throw new IllegalStateException("Cannot make a method annotated with @Inject a @PostConstruct handler");
        }
        if (this.hasAnnotation("jakarta.annotation.PreDestroy")) {
            throw new IllegalStateException("Cannot make a method annotated with @PreDestroy a @PostConstruct handler");
        }
        this.annotate("jakarta.annotation.PostConstruct");
        return this;
    }

    @NonNull
    default public BeanMethodElement withParameters(@NonNull Consumer<BeanParameterElement[]> parameterConsumer) {
        Objects.requireNonNull(parameterConsumer, "The parameter consumer cannot be null");
        parameterConsumer.accept(this.getParameters());
        return this;
    }

    @NonNull
    public BeanParameterElement[] getParameters();
}

