/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.annotation.AbstractElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import java.util.ArrayList;

@Internal
public final class GenericPlaceholderElementAnnotationMetadata
extends AbstractElementAnnotationMetadata {
    private final GenericPlaceholderElement genericPlaceholderElement;
    private final ClassElement representingClassElement;
    private AnnotationMetadata annotationMetadata;

    public GenericPlaceholderElementAnnotationMetadata(GenericPlaceholderElement genericPlaceholderElement, ClassElement representingClassElement) {
        this.genericPlaceholderElement = genericPlaceholderElement;
        this.representingClassElement = representingClassElement;
    }

    @Override
    public AnnotationMetadata getReturnInstance() {
        return this.getAnnotationMetadata();
    }

    @Override
    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        return this.genericPlaceholderElement.getGenericTypeAnnotationMetadata();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        if (this.annotationMetadata == null) {
            ArrayList<MutableAnnotationMetadataDelegate<AnnotationMetadata>> allAnnotationMetadata = new ArrayList<MutableAnnotationMetadataDelegate<AnnotationMetadata>>();
            this.genericPlaceholderElement.getBounds().forEach(ce -> allAnnotationMetadata.add(ce.getTypeAnnotationMetadata()));
            allAnnotationMetadata.add(this.representingClassElement.getTypeAnnotationMetadata());
            allAnnotationMetadata.add(this.genericPlaceholderElement.getGenericTypeAnnotationMetadata());
            this.genericPlaceholderElement.getResolved().ifPresent(ClassElement::getTypeAnnotationMetadata);
            this.annotationMetadata = new AnnotationMetadataHierarchy(true, (AnnotationMetadata[])allAnnotationMetadata.toArray(AnnotationMetadata[]::new));
        }
        return this.annotationMetadata;
    }
}

