/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.GenericElement;
import java.util.List;

public interface WildcardElement
extends GenericElement {
    @NonNull
    public List<? extends ClassElement> getUpperBounds();

    @NonNull
    public List<? extends ClassElement> getLowerBounds();

    default public boolean isBounded() {
        return !this.getName().equals("java.lang.Object");
    }

    @NonNull
    public static <T extends ClassElement> T findUpperType(@NonNull List<T> bounds1, @NonNull List<T> bounds2) {
        ClassElement upper = null;
        for (ClassElement lowerBound : bounds2) {
            if (upper != null && !lowerBound.isAssignable(upper)) continue;
            upper = lowerBound;
        }
        for (ClassElement upperBound : bounds1) {
            if (upper != null && !upperBound.isAssignable(upper)) continue;
            upper = upperBound;
        }
        return (T)upper;
    }
}

