/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import java.util.Objects;

public final class PrimitiveElement
implements ArrayableClassElement {
    public static final PrimitiveElement VOID = new PrimitiveElement("void", null);
    public static final PrimitiveElement BOOLEAN = new PrimitiveElement("boolean", Boolean.class);
    public static final PrimitiveElement INT = new PrimitiveElement("int", Integer.class);
    public static final PrimitiveElement CHAR = new PrimitiveElement("char", Character.class);
    public static final PrimitiveElement LONG = new PrimitiveElement("long", Long.class);
    public static final PrimitiveElement FLOAT = new PrimitiveElement("float", Float.class);
    public static final PrimitiveElement DOUBLE = new PrimitiveElement("double", Double.class);
    public static final PrimitiveElement SHORT = new PrimitiveElement("short", Short.class);
    public static final PrimitiveElement BYTE = new PrimitiveElement("byte", Byte.class);
    private static final PrimitiveElement[] PRIMITIVES = new PrimitiveElement[]{INT, CHAR, BOOLEAN, LONG, FLOAT, DOUBLE, SHORT, BYTE, VOID};
    private final String typeName;
    private final int arrayDimensions;
    private final String boxedTypeName;

    private PrimitiveElement(String name, @Nullable Class<?> boxedType) {
        this(name, boxedType == null ? "<>" : boxedType.getName(), 0);
    }

    private PrimitiveElement(String name, String boxedTypeName, int arrayDimensions) {
        this.typeName = name;
        this.arrayDimensions = arrayDimensions;
        this.boxedTypeName = boxedTypeName;
    }

    @Override
    public boolean isAssignable(String type) {
        return this.typeName.equals(type) || this.boxedTypeName.equals(type) || Object.class.getName().equals(type);
    }

    @Override
    public boolean isAssignable(ClassElement type) {
        if (this == type) {
            return true;
        }
        if (!(!this.isArray() || type.isPrimitive() && type.isArray() && type.getArrayDimensions() == this.getArrayDimensions())) {
            return false;
        }
        return this.isAssignable(type.getName());
    }

    @Override
    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    @Override
    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    @Override
    @NonNull
    public String getName() {
        return this.typeName;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    @NonNull
    public Object getNativeType() {
        throw new UnsupportedOperationException("There is no native types for primitives");
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return AnnotationMetadata.EMPTY_METADATA;
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new PrimitiveElement(this.typeName, this.boxedTypeName, arrayDimensions);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public static PrimitiveElement valueOf(String name) {
        for (PrimitiveElement element : PRIMITIVES) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            return element;
        }
        throw new IllegalArgumentException(String.format("No primitive found for name: %s", name));
    }

    public String toString() {
        return "PrimitiveElement{typeName='" + this.typeName + "', arrayDimensions=" + this.arrayDimensions + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveElement that = (PrimitiveElement)o;
        return this.arrayDimensions == that.arrayDimensions && this.typeName.equals(that.typeName);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.arrayDimensions);
    }
}

