/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ReflectParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface ParameterElement
extends TypedElement {
    @Override
    @NonNull
    public ClassElement getType();

    @Override
    @NonNull
    default public String getDescription(boolean simple) {
        if (simple) {
            return this.getType().getSimpleName() + " " + this.getName();
        }
        return this.getType().getName() + " " + this.getName();
    }

    default public MethodElement getMethodElement() {
        throw new IllegalStateException("Method element is not supported!");
    }

    @Override
    default public ParameterElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (ParameterElement)TypedElement.super.withAnnotationMetadata(annotationMetadata);
    }

    @NonNull
    public static ParameterElement of(@NonNull Class<?> type, @NonNull String name) {
        return ParameterElement.of(ClassElement.of(type), name);
    }

    @NonNull
    public static ParameterElement of(@NonNull ClassElement type, @NonNull String name) {
        Objects.requireNonNull(name, "Name cannot be null");
        Objects.requireNonNull(type, "Type cannot be null");
        return new ReflectParameterElement(type, name);
    }

    @NonNull
    public static ParameterElement of(final @NonNull ClassElement type, final @NonNull String name, final @NonNull AnnotationMetadataProvider annotationMetadataProvider, final @NonNull AbstractAnnotationMetadataBuilder<?, ?> metadataBuilder) {
        Objects.requireNonNull(name, "Name cannot be null");
        Objects.requireNonNull(type, "Type cannot be null");
        return new ReflectParameterElement(type, name){
            private AnnotationMetadata annotationMetadata;

            @Override
            public ParameterElement withAnnotationMetadata(final AnnotationMetadata annotationMetadata) {
                return ParameterElement.of(type, name, new AnnotationMetadataProvider(){

                    public AnnotationMetadata getAnnotationMetadata() {
                        return annotationMetadata;
                    }
                }, metadataBuilder);
            }

            @Override
            public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
                ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
                AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
                if (consumer != null) {
                    consumer.accept(builder);
                    AnnotationValue av = builder.build();
                    this.annotationMetadata = metadataBuilder.annotate(this.getAnnotationMetadata(), av);
                }
                return this;
            }

            @Override
            public AnnotationMetadata getAnnotationMetadata() {
                if (this.annotationMetadata == null) {
                    this.annotationMetadata = annotationMetadataProvider.getAnnotationMetadata();
                }
                return this.annotationMetadata;
            }

            @Override
            public <T extends Annotation> Element annotate(AnnotationValue<T> annotationValue) {
                ArgumentUtils.requireNonNull((String)"annotationValue", annotationValue);
                this.annotationMetadata = metadataBuilder.annotate(this.getAnnotationMetadata(), annotationValue);
                return this;
            }

            @Override
            public Element removeAnnotation(@NonNull String annotationType) {
                ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
                this.annotationMetadata = metadataBuilder.removeAnnotation(this.getAnnotationMetadata(), annotationType);
                return this;
            }

            @Override
            public <T extends Annotation> Element removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
                ArgumentUtils.requireNonNull((String)"predicate", predicate);
                this.annotationMetadata = metadataBuilder.removeAnnotationIf(this.getAnnotationMetadata(), predicate);
                return this;
            }

            @Override
            public Element removeStereotype(@NonNull String annotationType) {
                ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
                this.annotationMetadata = metadataBuilder.removeStereotype(this.getAnnotationMetadata(), annotationType);
                return this;
            }
        };
    }
}

