/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation.internal;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.annotation.AnnotationRemapper;
import io.micronaut.inject.visitor.VisitorContext;
import jakarta.inject.Qualifier;
import java.util.List;
import java.util.Optional;

@Internal
public final class QualifierBindingMembers
implements AnnotationRemapper {
    @Override
    public String getPackageName() {
        return "*";
    }

    @Override
    public List<AnnotationValue<?>> remap(AnnotationValue<?> annotation, VisitorContext visitorContext) {
        Optional<AnnotationValue> qualifier;
        String[] nonBindingMembers;
        if (annotation.getStereotypes() != null && (nonBindingMembers = annotation.stringValues("$nonBinding")).length > 0 && (qualifier = annotation.getStereotypes().stream().filter(av -> av.getAnnotationName().equals("jakarta.inject.Qualifier") || av.getAnnotationName().equals(Qualifier.class.getName())).findFirst()).isPresent()) {
            AnnotationValue originalQualifier = qualifier.get();
            AnnotationValue newQualifier = originalQualifier.mutate().member("$nonBinding", nonBindingMembers).build();
            annotation = annotation.mutate().replaceStereotype(originalQualifier, newQualifier).build();
        }
        return List.of(annotation);
    }
}

