/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation.internal;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.annotation.AnnotationRemapper;
import io.micronaut.inject.visitor.VisitorContext;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Internal
public final class JavaxRemapper
implements AnnotationRemapper {
    private static final Pattern JAVAX = Pattern.compile("^javax");

    @Override
    @NonNull
    public String getPackageName() {
        return "javax.inject";
    }

    @Override
    @NonNull
    public List<AnnotationValue<?>> remap(AnnotationValue<?> annotation, VisitorContext visitorContext) {
        String name = annotation.getAnnotationName();
        Matcher matcher = JAVAX.matcher(name);
        AnnotationValue stereotype = null;
        if (name.equals(Named.class.getName())) {
            stereotype = AnnotationValue.builder((String)"jakarta.inject.Qualifier").build();
        } else if (name.equals(Singleton.class.getName())) {
            stereotype = AnnotationValue.builder((String)"jakarta.inject.Scope").build();
        }
        return Collections.singletonList(AnnotationValue.builder((String)matcher.replaceFirst("jakarta")).members(annotation.getValues()).stereotype(stereotype).build());
    }
}

