/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation.internal;

import io.micronaut.aop.Around;
import io.micronaut.aop.AroundConstruct;
import io.micronaut.aop.InterceptorBinding;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.Introduction;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.annotation.AnnotationRemapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Internal
public final class InterceptorBindingMembers
implements AnnotationRemapper {
    private static final Set<String> SKIP_ANNOTATIONS = Set.of(Around.class.getName(), AroundConstruct.class.getName(), InterceptorBinding.class.getName(), Introduction.class.getName());

    @Override
    public String getPackageName() {
        return "*";
    }

    @Override
    public List<AnnotationValue<?>> remap(AnnotationValue<?> annotationValue, VisitorContext visitorContext) {
        boolean hasInterceptorBinding;
        if (annotationValue.getStereotypes() == null) {
            return List.of(annotationValue);
        }
        String annotationName = annotationValue.getAnnotationName();
        if (SKIP_ANNOTATIONS.contains(annotationName)) {
            return List.of(annotationValue.mutate().replaceStereotypes(Collections.emptyList()).build());
        }
        ArrayList<AnnotationValueBuilder> interceptorBindings = new ArrayList<AnnotationValueBuilder>();
        for (Object stereotype : annotationValue.getStereotypes()) {
            String stereotypeName = stereotype.getAnnotationName();
            AnnotationValueBuilder newInterceptorBinding = null;
            if (InterceptorBinding.class.getName().equals(stereotypeName)) {
                newInterceptorBinding = stereotype.mutate().member("value", new AnnotationClassValue[]{new AnnotationClassValue(annotationName)});
                if (stereotype.booleanValue("bindMembers").orElse(false).booleanValue()) {
                    String[] nonBinding = annotationValue.stringValues("$nonBinding");
                    LinkedHashMap bindingValues = annotationValue.getValues();
                    bindingValues = new LinkedHashMap(bindingValues);
                    Arrays.asList(nonBinding).forEach(bindingValues.keySet()::remove);
                    AnnotationValue binding = AnnotationValue.builder((String)annotationValue.getAnnotationName()).members(bindingValues).build();
                    newInterceptorBinding.member("$bindingValues", binding);
                }
            } else if (Around.class.getName().equals(stereotypeName)) {
                newInterceptorBinding = AnnotationValue.builder(InterceptorBinding.class).member("value", new AnnotationClassValue[]{new AnnotationClassValue(annotationName)}).member("kind", (Enum)InterceptorKind.AROUND);
            } else if (Introduction.class.getName().equals(stereotypeName)) {
                newInterceptorBinding = AnnotationValue.builder(InterceptorBinding.class).member("value", new AnnotationClassValue[]{new AnnotationClassValue(annotationName)}).member("kind", (Enum)InterceptorKind.INTRODUCTION);
            } else if (AroundConstruct.class.getName().equals(stereotypeName)) {
                newInterceptorBinding = AnnotationValue.builder(InterceptorBinding.class).member("value", new AnnotationClassValue[]{new AnnotationClassValue(annotationName)}).member("kind", (Enum)InterceptorKind.AROUND_CONSTRUCT);
            }
            if (newInterceptorBinding == null) continue;
            interceptorBindings.add(newInterceptorBinding);
        }
        boolean bl = hasInterceptorBinding = !interceptorBindings.isEmpty();
        if (hasInterceptorBinding) {
            for (AnnotationValue av : annotationValue.getStereotypes()) {
                AnnotationClassValue[] annotationClassValues;
                if (!Type.class.getName().equals(av.getAnnotationName())) continue;
                Object o = av.getValues().get("value");
                AnnotationClassValue interceptorType = null;
                if (o instanceof AnnotationClassValue) {
                    AnnotationClassValue annotationClassValue;
                    interceptorType = annotationClassValue = (AnnotationClassValue)o;
                } else if (o instanceof AnnotationClassValue[] && (annotationClassValues = (AnnotationClassValue[])o).length > 0) {
                    interceptorType = annotationClassValues[0];
                }
                if (interceptorType == null) break;
                for (AnnotationValueBuilder interceptorBinding : interceptorBindings) {
                    interceptorBinding.member("interceptorType", new AnnotationClassValue[]{interceptorType});
                }
            }
        }
        if (!interceptorBindings.isEmpty()) {
            AnnotationValue[] interceptors = (AnnotationValue[])interceptorBindings.stream().map(AnnotationValueBuilder::build).toArray(AnnotationValue[]::new);
            AnnotationValue interceptorsContainer = AnnotationValue.builder((String)"io.micronaut.aop.InterceptorBindingDefinitions").values(interceptors).build();
            annotationValue = annotationValue.mutate().stereotype(interceptorsContainer).build();
        }
        return List.of(annotationValue);
    }
}

