/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.token;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.expressions.parser.exception.ExpressionParsingException;
import io.micronaut.expressions.parser.token.Token;
import io.micronaut.expressions.parser.token.TokenType;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Internal
public final class Tokenizer {
    private static final Map<String, TokenType> TOKENS = CollectionUtils.mapOf((Object[])new Object[]{"^\\s+", TokenType.WHITESPACE, "^\\{", TokenType.L_CURLY, "^}", TokenType.R_CURLY, "^\\[", TokenType.L_SQUARE, "^]", TokenType.R_SQUARE, "^\\(", TokenType.L_PAREN, "^\\)", TokenType.R_PAREN, "^instanceof\\b", TokenType.INSTANCEOF, "^matches\\b", TokenType.MATCHES, "^empty\\b", TokenType.EMPTY, "^ctx\\b", TokenType.BEAN_CONTEXT, "^env\\b", TokenType.ENVIRONMENT, "^this\\b", TokenType.THIS, "^null\\b", TokenType.NULL, "^(true|false)\\b", TokenType.BOOL, "^'[^']*'", TokenType.STRING, "^\\d+\\.\\d*((e|E)(\\+|-)?\\d+)?(f|F)", TokenType.FLOAT, "^\\.\\d+((e|E)(\\+|-)?\\d+)?(f|F)", TokenType.FLOAT, "^\\d+((e|E)(\\+|-)?\\d+)?(f|F)", TokenType.FLOAT, "^\\d+\\.\\d*((e|E)(\\+|-)?\\d+)?(d|D)?", TokenType.DOUBLE, "^\\.\\d+((e|E)(\\+|-)?\\d+)?(d|D)?", TokenType.DOUBLE, "^\\d+((e|E)(\\+|-)?\\d+)(d|D)?", TokenType.DOUBLE, "^\\d+((e|E)(\\+|-)?\\d+)?(d|D)", TokenType.DOUBLE, "^0(x|X)[0-9a-fA-F]+(l|L)", TokenType.LONG, "^\\d+(l|L)", TokenType.LONG, "^0(x|X)[0-9a-fA-F]+", TokenType.INT, "^\\d+", TokenType.INT, "^#", TokenType.EXPRESSION_CONTEXT_REF, "^\\?\\.", TokenType.SAFE_NAV, "^\\?\\:", TokenType.ELVIS, "^\\?", TokenType.QMARK, "^\\.", TokenType.DOT, "^,", TokenType.COMMA, "^\\:", TokenType.COLON, "^==", TokenType.EQ, "^!=", TokenType.NE, "^>=", TokenType.GTE, "^>", TokenType.GT, "^<=", TokenType.LTE, "^<", TokenType.LT, "^!", TokenType.NOT, "^not\\b", TokenType.NOT, "^&&", TokenType.AND, "^and\\b", TokenType.AND, "^\\|\\|", TokenType.OR, "^or\\b", TokenType.OR, "^\\+\\+", TokenType.INCREMENT, "^\\+", TokenType.PLUS, "^\\-\\-", TokenType.DECREMENT, "^\\-", TokenType.MINUS, "^\\*", TokenType.MUL, "^/", TokenType.DIV, "^div\\b", TokenType.DIV, "^%", TokenType.MOD, "^mod\\b", TokenType.MOD, "^\\^", TokenType.POW, "^T\\(", TokenType.TYPE_IDENTIFIER, "\\w+", TokenType.IDENTIFIER});
    private static final List<TokenPattern> PATTERNS = TOKENS.entrySet().stream().map(entry -> TokenPattern.of((String)entry.getKey(), (TokenType)((Object)((Object)entry.getValue())))).toList();
    private final int length;
    private final String expression;
    private int cursor;
    private String remaining;

    public Tokenizer(String expression) {
        this.expression = expression;
        this.remaining = expression;
        this.cursor = 0;
        this.length = expression.length();
    }

    @Nullable
    public Token getNextToken() {
        if (!this.hasMoreTokens()) {
            return null;
        }
        this.remaining = this.expression.substring(this.cursor);
        for (TokenPattern pattern : PATTERNS) {
            Token token = pattern.matches(this.remaining);
            if (token == null) continue;
            this.cursor += token.value().length();
            if (token.type() == TokenType.WHITESPACE) {
                return this.getNextToken();
            }
            return token;
        }
        throw new ExpressionParsingException("Unexpected token: " + this.remaining);
    }

    private boolean hasMoreTokens() {
        return this.cursor < this.length;
    }

    private record TokenPattern(Pattern pattern, TokenType tokenType) {
        public static TokenPattern of(String pattern, TokenType tokenType) {
            return new TokenPattern(Pattern.compile(pattern), tokenType);
        }

        @Nullable
        public Token matches(String value) {
            Matcher matcher = this.pattern.matcher(value);
            if (!matcher.find()) {
                return null;
            }
            return new Token(this.tokenType, matcher.group());
        }
    }
}

