/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.expressions.ExpressionEvaluationContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;

@Internal
public final class TypeDescriptors {
    public static final Type EVALUATION_CONTEXT_TYPE = Type.getType(ExpressionEvaluationContext.class);
    public static final Type STRING = Type.getType(String.class);
    public static final Type OBJECT = Type.getType(Object.class);
    public static final Type CLASS = Type.getType(Class.class);
    public static final Type VOID = Type.VOID_TYPE;
    public static final Type DOUBLE = Type.DOUBLE_TYPE;
    public static final Type FLOAT = Type.FLOAT_TYPE;
    public static final Type INT = Type.INT_TYPE;
    public static final Type LONG = Type.LONG_TYPE;
    public static final Type BOOLEAN = Type.BOOLEAN_TYPE;
    public static final Type CHAR = Type.CHAR_TYPE;
    public static final Type SHORT = Type.SHORT_TYPE;
    public static final Type BYTE = Type.BYTE_TYPE;
    public static final Type BOOLEAN_WRAPPER = Type.getType(Boolean.class);
    public static final Type INT_WRAPPER = Type.getType(Integer.class);
    public static final Type LONG_WRAPPER = Type.getType(Long.class);
    public static final Type DOUBLE_WRAPPER = Type.getType(Double.class);
    public static final Type FLOAT_WRAPPER = Type.getType(Float.class);
    public static final Type SHORT_WRAPPER = Type.getType(Short.class);
    public static final Type BYTE_WRAPPER = Type.getType(Byte.class);
    public static final Type CHAR_WRAPPER = Type.getType(Character.class);
    public static final Map<Type, Type> PRIMITIVE_TO_WRAPPER = Map.of(BOOLEAN, BOOLEAN_WRAPPER, INT, INT_WRAPPER, DOUBLE, DOUBLE_WRAPPER, LONG, LONG_WRAPPER, FLOAT, FLOAT_WRAPPER, SHORT, SHORT_WRAPPER, CHAR, CHAR_WRAPPER, BYTE, BYTE_WRAPPER);
    public static final Map<Type, Type> WRAPPER_TO_PRIMITIVE = PRIMITIVE_TO_WRAPPER.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));

    public static boolean isPrimitive(@NonNull Type type) {
        return PRIMITIVE_TO_WRAPPER.containsKey(type);
    }

    public static boolean isBoolean(@NonNull Type type) {
        return TypeDescriptors.isOneOf(type, BOOLEAN, BOOLEAN_WRAPPER);
    }

    @NonNull
    public static boolean isNumeric(@NonNull Type type) {
        return TypeDescriptors.isOneOf(type, DOUBLE, DOUBLE_WRAPPER, FLOAT, FLOAT_WRAPPER, INT, INT_WRAPPER, LONG, LONG_WRAPPER, SHORT, SHORT_WRAPPER, CHAR, CHAR_WRAPPER, BYTE, BYTE_WRAPPER);
    }

    @NonNull
    public static Type toUnboxedIfNecessary(@NonNull Type type) {
        if (WRAPPER_TO_PRIMITIVE.containsKey(type)) {
            return WRAPPER_TO_PRIMITIVE.get(type);
        }
        return type;
    }

    @NonNull
    public static Type toBoxedIfNecessary(@NonNull Type type) {
        if (PRIMITIVE_TO_WRAPPER.containsKey(type)) {
            return PRIMITIVE_TO_WRAPPER.get(type);
        }
        return type;
    }

    @NonNull
    public static Type computeNumericOperationTargetType(@NonNull Type leftOperandType, @NonNull Type rightOperandType) {
        if (!TypeDescriptors.isNumeric(leftOperandType) || !TypeDescriptors.isNumeric(rightOperandType)) {
            throw new ExpressionCompilationException("Numeric operation can only be applied to numeric types");
        }
        if (TypeDescriptors.toUnboxedIfNecessary(leftOperandType).equals((Object)DOUBLE) || TypeDescriptors.toUnboxedIfNecessary(rightOperandType).equals((Object)DOUBLE)) {
            return DOUBLE;
        }
        if (TypeDescriptors.toUnboxedIfNecessary(leftOperandType).equals((Object)FLOAT) || TypeDescriptors.toUnboxedIfNecessary(rightOperandType).equals((Object)FLOAT)) {
            return FLOAT;
        }
        if (TypeDescriptors.toUnboxedIfNecessary(leftOperandType).equals((Object)LONG) || TypeDescriptors.toUnboxedIfNecessary(rightOperandType).equals((Object)LONG)) {
            return LONG;
        }
        return INT;
    }

    public static boolean isOneOf(Type type, Type ... comparedTypes) {
        for (Type comparedType : comparedTypes) {
            if (!type.equals((Object)comparedType)) continue;
            return true;
        }
        return false;
    }
}

