/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.unary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import org.objectweb.asm.Type;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class UnaryOperator
extends ExpressionNode {
    protected final ExpressionNode operand;

    public UnaryOperator(ExpressionNode operand) {
        this.operand = operand;
    }

    @Override
    public Type doResolveType(ExpressionVisitorContext ctx) {
        return this.operand.resolveType(ctx);
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        Type type = this.doResolveType(ctx);
        try {
            return PrimitiveElement.valueOf(type.getClassName());
        }
        catch (IllegalArgumentException e) {
            return ClassElement.of(type.getClassName());
        }
    }
}

