/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.unary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.unary.UnaryOperator;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

@Internal
public final class NegOperator
extends UnaryOperator {
    public NegOperator(ExpressionNode operand) {
        super(operand);
    }

    @Override
    public Type doResolveType(ExpressionVisitorContext ctx) {
        Type nodeType = super.doResolveType(ctx);
        if (!TypeDescriptors.isNumeric(nodeType)) {
            throw new ExpressionCompilationException("Invalid unary '-' operation. Unary '-' can only be applied to numeric types");
        }
        return nodeType;
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        this.operand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(this.operand.resolveType(ctx), mv);
        if (TypeDescriptors.isOneOf(this.operand.resolveType(ctx), TypeDescriptors.INT, TypeDescriptors.INT_WRAPPER)) {
            mv.visitInsn(116);
        } else if (TypeDescriptors.isOneOf(this.operand.resolveType(ctx), TypeDescriptors.DOUBLE, TypeDescriptors.DOUBLE_WRAPPER)) {
            mv.visitInsn(119);
        } else if (TypeDescriptors.isOneOf(this.operand.resolveType(ctx), TypeDescriptors.FLOAT, TypeDescriptors.FLOAT_WRAPPER)) {
            mv.visitInsn(118);
        } else if (TypeDescriptors.isOneOf(this.operand.resolveType(ctx), TypeDescriptors.LONG, TypeDescriptors.LONG_WRAPPER)) {
            mv.visitInsn(117);
        } else {
            throw new ExpressionCompilationException("Invalid unary '-' operation. Unary '-' can only be applied to numeric types");
        }
    }
}

