/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.binary.ComparablesComparisonOperation;
import io.micronaut.expressions.parser.ast.operator.binary.NumericComparisonOperation;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import org.objectweb.asm.Type;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class RelationalOperator
extends ExpressionNode {
    protected final ExpressionNode leftOperand;
    protected final ExpressionNode rightOperand;
    private ExpressionNode comparisonOperation;

    public RelationalOperator(ExpressionNode leftOperand, ExpressionNode rightOperand) {
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    protected abstract Integer intComparisonOpcode();

    protected abstract Integer nonIntComparisonOpcode();

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        Type leftType = this.leftOperand.resolveType(ctx);
        Type rightType = this.rightOperand.resolveType(ctx);
        this.comparisonOperation = TypeDescriptors.isNumeric(leftType) && TypeDescriptors.isNumeric(rightType) ? new NumericComparisonOperation(this.leftOperand, this.rightOperand, this.intComparisonOpcode(), this.nonIntComparisonOpcode()) : new ComparablesComparisonOperation(this.leftOperand, this.rightOperand, this.nonIntComparisonOpcode());
        return this.comparisonOperation.resolveType(ctx);
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        this.comparisonOperation.compile(ctx);
    }
}

