/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.binary.BinaryOperator;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class PowOperator
extends BinaryOperator {
    private static final Type MATH_TYPE = Type.getType(Math.class);
    private static final Method POW_METHOD = new Method("pow", TypeDescriptors.DOUBLE, new Type[]{TypeDescriptors.DOUBLE, TypeDescriptors.DOUBLE});

    public PowOperator(ExpressionNode leftOperand, ExpressionNode rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        Type leftType = this.leftOperand.resolveType(ctx);
        Type rightType = this.rightOperand.resolveType(ctx);
        this.leftOperand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(leftType, mv);
        EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(leftType, TypeDescriptors.DOUBLE, mv);
        this.rightOperand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(leftType, mv);
        EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(rightType, TypeDescriptors.DOUBLE, mv);
        mv.invokeStatic(MATH_TYPE, POW_METHOD);
        if (this.resolveType(ctx) == TypeDescriptors.LONG) {
            EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(TypeDescriptors.DOUBLE, TypeDescriptors.LONG, mv);
        }
    }

    @Override
    protected Type resolveOperationType(Type leftOperandType, Type rightOperandType) {
        if (!TypeDescriptors.isNumeric(leftOperandType) || !TypeDescriptors.isNumeric(rightOperandType)) {
            throw new ExpressionCompilationException("Power operation can only be applied to numeric types");
        }
        if (TypeDescriptors.isOneOf(TypeDescriptors.toUnboxedIfNecessary(leftOperandType), TypeDescriptors.DOUBLE, TypeDescriptors.FLOAT) || TypeDescriptors.isOneOf(TypeDescriptors.toUnboxedIfNecessary(rightOperandType), TypeDescriptors.DOUBLE, TypeDescriptors.FLOAT)) {
            return TypeDescriptors.DOUBLE;
        }
        return TypeDescriptors.LONG;
    }
}

