/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.binary.MathOperator;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import java.util.Map;
import java.util.Optional;
import org.objectweb.asm.Type;

@Internal
public final class MulOperator
extends MathOperator {
    private static final Map<String, Integer> MUL_OPERATION_OPCODES = Map.of("D", 107, "I", 104, "F", 106, "J", 105);

    public MulOperator(ExpressionNode leftOperand, ExpressionNode rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    protected int getMathOperationOpcode(ExpressionVisitorContext ctx) {
        Type type = this.resolveType(ctx);
        String typeDescriptor = type.getDescriptor();
        return Optional.ofNullable(MUL_OPERATION_OPCODES.get(typeDescriptor)).orElseThrow(() -> new ExpressionCompilationException("'*' operation can not be applied to " + type));
    }
}

