/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.binary.BinaryOperator;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class MathOperator
extends BinaryOperator {
    public MathOperator(ExpressionNode leftOperand, ExpressionNode rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        Type targetType = this.resolveType(ctx);
        Type leftType = this.leftOperand.resolveType(ctx);
        this.leftOperand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(leftType, mv);
        EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(leftType, targetType, mv);
        Type rightType = this.rightOperand.resolveType(ctx);
        this.rightOperand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(rightType, mv);
        EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(rightType, targetType, mv);
        mv.visitInsn(this.getMathOperationOpcode(ctx));
    }

    @Override
    protected Type resolveOperationType(Type leftOperandType, Type rightOperandType) {
        return TypeDescriptors.computeNumericOperationTargetType(leftOperandType, rightOperandType);
    }

    protected abstract int getMathOperationOpcode(ExpressionVisitorContext var1);
}

