/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.literal.StringLiteral;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class MatchesOperator
extends ExpressionNode {
    private static final Method MATCHES = new Method("matches", TypeDescriptors.BOOLEAN, new Type[]{TypeDescriptors.STRING});
    private final ExpressionNode operand;
    private final StringLiteral pattern;

    public MatchesOperator(ExpressionNode operand, StringLiteral pattern) {
        this.operand = operand;
        this.pattern = pattern;
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        this.operand.compile(ctx);
        this.pattern.compile(ctx);
        mv.invokeVirtual(TypeDescriptors.STRING, MATCHES);
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        return PrimitiveElement.BOOLEAN;
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        if (!this.operand.resolveType(ctx).equals((Object)TypeDescriptors.STRING)) {
            throw new ExpressionCompilationException("Operator 'matches' can only be applied to String operand");
        }
        String patternValue = this.pattern.getValue();
        try {
            Pattern.compile(patternValue);
        }
        catch (PatternSyntaxException ex) {
            throw new ExpressionCompilationException("Invalid RegEx pattern provided: " + patternValue);
        }
        return TypeDescriptors.BOOLEAN;
    }
}

