/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.binary.BinaryOperator;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import org.objectweb.asm.Type;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class LogicalOperator
extends BinaryOperator {
    public LogicalOperator(ExpressionNode leftOperand, ExpressionNode rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    protected Type resolveOperationType(Type leftOperandType, Type rightOperandType) {
        if (!TypeDescriptors.isBoolean(leftOperandType) && !TypeDescriptors.isBoolean(rightOperandType)) {
            throw new ExpressionCompilationException("Logical operation can only be applied to boolean types");
        }
        return Type.BOOLEAN_TYPE;
    }
}

