/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.types.TypeIdentifier;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

@Internal
public final class InstanceofOperator
extends ExpressionNode {
    private final ExpressionNode operand;
    private final TypeIdentifier typeIdentifier;

    public InstanceofOperator(ExpressionNode operand, TypeIdentifier typeIdentifier) {
        this.operand = operand;
        this.typeIdentifier = typeIdentifier;
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        Type targetType = this.typeIdentifier.resolveType(ctx);
        if (TypeDescriptors.isPrimitive(targetType)) {
            throw new ExpressionCompilationException("'instanceof' operation can not be used with primitive right-hand side type");
        }
        GeneratorAdapter mv = ctx.methodVisitor();
        Type expressionType = this.operand.resolveType(ctx);
        this.operand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(expressionType, mv);
        mv.visitTypeInsn(193, targetType.getInternalName());
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        return PrimitiveElement.BOOLEAN;
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        return TypeDescriptors.BOOLEAN;
    }
}

