/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.binary.BinaryOperator;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public class EqOperator
extends BinaryOperator {
    public EqOperator(ExpressionNode leftOperand, ExpressionNode rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        Type lefType = this.leftOperand.resolveType(ctx);
        Type rightType = this.rightOperand.resolveType(ctx);
        this.leftOperand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(lefType, mv);
        this.rightOperand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(rightType, mv);
        mv.invokeStatic(Type.getType(Objects.class), new Method("equals", TypeDescriptors.BOOLEAN, new Type[]{TypeDescriptors.OBJECT, TypeDescriptors.OBJECT}));
    }

    @Override
    protected Type resolveOperationType(Type leftOperandType, Type rightOperandType) {
        return TypeDescriptors.BOOLEAN;
    }
}

