/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.binary.LogicalOperator;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.GeneratorAdapter;

@Internal
public final class AndOperator
extends LogicalOperator {
    public AndOperator(ExpressionNode leftOperand, ExpressionNode rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        Label falseLabel = new Label();
        Label trueLabel = new Label();
        this.pushOperand(ctx, this.leftOperand, falseLabel);
        this.pushOperand(ctx, this.rightOperand, falseLabel);
        mv.push(true);
        mv.visitJumpInsn(167, trueLabel);
        mv.visitLabel(falseLabel);
        mv.push(false);
        mv.visitLabel(trueLabel);
    }

    private void pushOperand(ExpressionVisitorContext ctx, ExpressionNode operand, Label falseLabel) {
        if (operand instanceof AndOperator) {
            AndOperator andOperator = (AndOperator)operand;
            this.pushOperand(ctx, andOperator.leftOperand, falseLabel);
            this.pushOperand(ctx, andOperator.rightOperand, falseLabel);
        } else if (operand != null) {
            GeneratorAdapter mv = ctx.methodVisitor();
            operand.compile(ctx);
            mv.visitJumpInsn(153, falseLabel);
        }
    }
}

