/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.collection;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.types.TypeIdentifier;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

@Internal
public final class OneDimensionalArray
extends ExpressionNode {
    private final TypeIdentifier elementTypeIdentifier;
    private final List<ExpressionNode> initializer;

    public OneDimensionalArray(TypeIdentifier elementTypeIdentifier, List<ExpressionNode> initializer) {
        this.elementTypeIdentifier = elementTypeIdentifier;
        this.initializer = initializer;
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        int arraySize = this.initializer.size();
        mv.push(arraySize);
        mv.newArray(this.elementTypeIdentifier.resolveType(ctx));
        if (arraySize > 0) {
            mv.dup();
        }
        for (int i = 0; i < arraySize; ++i) {
            ExpressionNode element = this.initializer.get(i);
            boolean isLastElement = i == arraySize - 1;
            mv.push(i);
            Type elementType = element.resolveType(ctx);
            element.compile(ctx);
            if (!this.elementTypeIdentifier.isPrimitive()) {
                EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(elementType, mv);
                mv.visitInsn(83);
            } else {
                mv.arrayStore(elementType);
            }
            if (isLastElement) continue;
            mv.dup();
        }
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        return EvaluatedExpressionCompilationUtils.getRequiredClassElement(this.elementTypeIdentifier.resolveType(ctx), ctx.visitorContext()).toArray();
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        return JavaModelUtils.getTypeReference(this.doResolveClassElement(ctx));
    }
}

