/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.processing.JavaModelUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class ThisAccess
extends ExpressionNode {
    @Override
    protected void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        mv.loadArg(0);
        mv.invokeInterface(TypeDescriptors.EVALUATION_CONTEXT_TYPE, new Method("getThis", Type.getType(Object.class), new Type[0]));
        mv.checkCast(this.resolveType(ctx));
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        ClassElement thisType = ctx.compilationContext().findThis();
        if (thisType == null) {
            throw new ExpressionCompilationException("Cannot reference 'this' from the current context.");
        }
        return thisType;
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        return JavaModelUtils.getTypeReference(this.doResolveClassElement(ctx));
    }
}

