/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class EnvironmentAccess
extends ExpressionNode {
    private static final ClassElement STRING_ELEMENT = ClassElement.of(String.class);
    private static final Method GET_PROPERTY_METHOD = new Method("getProperty", Type.getType(String.class), new Type[]{Type.getType(String.class)});
    private final ExpressionNode propertyName;

    public EnvironmentAccess(ExpressionNode propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    protected void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        mv.loadArg(0);
        this.propertyName.compile(ctx);
        mv.invokeInterface(TypeDescriptors.EVALUATION_CONTEXT_TYPE, GET_PROPERTY_METHOD);
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        this.resolveType(ctx);
        return ctx.visitorContext().getClassElement(String.class).orElse(STRING_ELEMENT);
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        Type propertyNameType = this.propertyName.resolveType(ctx);
        if (!propertyNameType.equals((Object)TypeDescriptors.STRING)) {
            throw new ExpressionCompilationException("Invalid environment access operation. The expression inside environment access must resolve to String value of property name");
        }
        return TypeDescriptors.STRING;
    }
}

