/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.processing.JavaModelUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
final class ContextMethodParameterAccess
extends ExpressionNode {
    private static final Method GET_ARGUMENT_METHOD = new Method("getArgument", Type.getType(Object.class), new Type[]{TypeDescriptors.INT});
    private final ParameterElement parameterElement;
    private Integer parameterIndex;

    public ContextMethodParameterAccess(ParameterElement parameterElement) {
        this.parameterElement = parameterElement;
    }

    @Override
    protected void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        mv.loadArg(0);
        mv.push(this.parameterIndex.intValue());
        mv.invokeInterface(TypeDescriptors.EVALUATION_CONTEXT_TYPE, GET_ARGUMENT_METHOD);
        if (this.nodeType != null) {
            mv.checkCast(this.nodeType);
        }
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        String parameterName = this.parameterElement.getName();
        ParameterElement[] methodParameters = this.parameterElement.getMethodElement().getParameters();
        Integer paramIndex = null;
        for (int i = 0; i < methodParameters.length; ++i) {
            ParameterElement methodParameter = methodParameters[i];
            if (!methodParameter.getName().equals(parameterName)) continue;
            paramIndex = i;
            break;
        }
        if (paramIndex == null) {
            throw new ExpressionCompilationException("Can not find parameter with name [" + parameterName + "] in method parameters");
        }
        this.parameterIndex = paramIndex;
        return this.parameterElement.getGenericType();
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        this.doResolveClassElement(ctx);
        return JavaModelUtils.getTypeReference(this.parameterElement.getType());
    }
}

