/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@Internal
final class CandidateMethod {
    private final MethodElement methodElement;
    private final List<ClassElement> parameterTypes;
    private final List<ClassElement> argumentTypes;
    private int varargsIndex = -1;

    public CandidateMethod(MethodElement methodElement, List<ClassElement> argumentTypes) {
        this.methodElement = methodElement;
        this.argumentTypes = argumentTypes;
        this.parameterTypes = Arrays.stream(methodElement.getParameters()).map(ParameterElement::getType).toList();
    }

    public CandidateMethod(MethodElement methodElement) {
        this(methodElement, Collections.emptyList());
    }

    public MethodElement getMethodElement() {
        return this.methodElement;
    }

    public boolean isVarArgs() {
        return this.getVarargsIndex() != -1;
    }

    public int getVarargsIndex() {
        return this.varargsIndex;
    }

    @NonNull
    public Type getReturnType() {
        return JavaModelUtils.getTypeReference(this.methodElement.getReturnType());
    }

    @NonNull
    public Type getOwningType() {
        return JavaModelUtils.getTypeReference(this.methodElement.getOwningType());
    }

    @NonNull
    public ClassElement getLastParameter() {
        return (ClassElement)CollectionUtils.last(this.parameterTypes);
    }

    @NonNull
    public String getDescriptor() {
        return this.toAsmMethod().getDescriptor();
    }

    @NonNull
    public List<ClassElement> getParameters() {
        return this.parameterTypes;
    }

    public boolean isMatching(VisitorContext ctx) {
        boolean varargsCandidate;
        int totalParams = this.parameterTypes.size();
        int totalArguments = this.argumentTypes.size();
        if (totalParams == 0) {
            return totalArguments == 0;
        }
        if (totalArguments < totalParams - 1) {
            return false;
        }
        ClassElement lastArgument = (ClassElement)CollectionUtils.last(this.argumentTypes);
        ClassElement lastParameter = this.getLastParameter();
        boolean bl = varargsCandidate = this.methodElement.isVarArgs() || lastParameter.isArray() && lastParameter.getArrayDimensions() == 1;
        if (varargsCandidate) {
            if (totalArguments == totalParams && EvaluatedExpressionCompilationUtils.isAssignable(lastParameter, lastArgument)) {
                return true;
            }
            if (this.isMatchingVarargs(ctx)) {
                this.varargsIndex = this.calculateVarargsIndex();
                return true;
            }
            return false;
        }
        if (totalArguments != totalParams) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            ClassElement argumentType = this.argumentTypes.get(i);
            ClassElement parameterType = this.parameterTypes.get(i);
            if (EvaluatedExpressionCompilationUtils.isAssignable(parameterType, argumentType)) continue;
            return false;
        }
        return true;
    }

    public Method toAsmMethod() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (TypedElement typedElement : this.parameterTypes) {
            builder.append(JavaModelUtils.getTypeReference(typedElement).getDescriptor());
        }
        builder.append(')');
        builder.append(JavaModelUtils.getTypeReference(this.methodElement.getReturnType()).getDescriptor());
        return new Method(this.methodElement.getSimpleName(), builder.toString());
    }

    private boolean isMatchingVarargs(VisitorContext ctx) {
        for (int paramIndex = 0; paramIndex < this.parameterTypes.size(); ++paramIndex) {
            boolean isLastParameter;
            ClassElement parameterType = this.parameterTypes.get(paramIndex);
            boolean bl = isLastParameter = paramIndex == this.parameterTypes.size() - 1;
            if (isLastParameter) {
                parameterType = EvaluatedExpressionCompilationUtils.getRequiredClassElement(JavaModelUtils.getTypeReference(parameterType).getElementType(), ctx);
                if (this.argumentTypes.size() < paramIndex) {
                    return true;
                }
                for (int argIndex = paramIndex; argIndex < this.argumentTypes.size(); ++argIndex) {
                    ClassElement argumentType = this.argumentTypes.get(paramIndex);
                    if (EvaluatedExpressionCompilationUtils.isAssignable(parameterType, argumentType)) continue;
                    return false;
                }
                return true;
            }
            if (this.argumentTypes.size() < paramIndex) {
                return false;
            }
            if (EvaluatedExpressionCompilationUtils.isAssignable(parameterType, this.argumentTypes.get(paramIndex))) continue;
            return false;
        }
        return false;
    }

    private int calculateVarargsIndex() {
        return CollectionUtils.last(this.parameterTypes) == null ? -1 : this.parameterTypes.size() - 1;
    }

    public String toString() {
        return this.methodElement.getDescription(false);
    }
}

