/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.types.TypeIdentifier;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.inject.ast.ClassElement;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public class BeanContextAccess
extends ExpressionNode {
    private static final Method GET_BEAN_METHOD = new Method("getBean", Type.getType(Object.class), new Type[]{Type.getType(Class.class)});
    private final TypeIdentifier typeIdentifier;

    public BeanContextAccess(TypeIdentifier typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    @Override
    protected void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        mv.loadArg(0);
        Type beanType = this.typeIdentifier.resolveType(ctx);
        mv.push(beanType);
        mv.invokeInterface(TypeDescriptors.EVALUATION_CONTEXT_TYPE, GET_BEAN_METHOD);
        mv.visitTypeInsn(192, beanType.getInternalName());
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        return this.typeIdentifier.resolveClassElement(ctx);
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        return this.typeIdentifier.doResolveType(ctx);
    }
}

