/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.EvaluatedExpressionParser;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.access.BeanContextAccess;
import io.micronaut.expressions.parser.ast.access.ContextElementAccess;
import io.micronaut.expressions.parser.ast.access.ContextMethodCall;
import io.micronaut.expressions.parser.ast.access.ElementMethodCall;
import io.micronaut.expressions.parser.ast.access.EnvironmentAccess;
import io.micronaut.expressions.parser.ast.access.PropertyAccess;
import io.micronaut.expressions.parser.ast.access.SubscriptOperator;
import io.micronaut.expressions.parser.ast.access.ThisAccess;
import io.micronaut.expressions.parser.ast.conditional.ElvisOperator;
import io.micronaut.expressions.parser.ast.conditional.TernaryExpression;
import io.micronaut.expressions.parser.ast.literal.BoolLiteral;
import io.micronaut.expressions.parser.ast.literal.DoubleLiteral;
import io.micronaut.expressions.parser.ast.literal.FloatLiteral;
import io.micronaut.expressions.parser.ast.literal.IntLiteral;
import io.micronaut.expressions.parser.ast.literal.LongLiteral;
import io.micronaut.expressions.parser.ast.literal.NullLiteral;
import io.micronaut.expressions.parser.ast.literal.StringLiteral;
import io.micronaut.expressions.parser.ast.operator.binary.AddOperator;
import io.micronaut.expressions.parser.ast.operator.binary.AndOperator;
import io.micronaut.expressions.parser.ast.operator.binary.DivOperator;
import io.micronaut.expressions.parser.ast.operator.binary.EqOperator;
import io.micronaut.expressions.parser.ast.operator.binary.GtOperator;
import io.micronaut.expressions.parser.ast.operator.binary.GteOperator;
import io.micronaut.expressions.parser.ast.operator.binary.InstanceofOperator;
import io.micronaut.expressions.parser.ast.operator.binary.LtOperator;
import io.micronaut.expressions.parser.ast.operator.binary.LteOperator;
import io.micronaut.expressions.parser.ast.operator.binary.MatchesOperator;
import io.micronaut.expressions.parser.ast.operator.binary.ModOperator;
import io.micronaut.expressions.parser.ast.operator.binary.MulOperator;
import io.micronaut.expressions.parser.ast.operator.binary.NeqOperator;
import io.micronaut.expressions.parser.ast.operator.binary.OrOperator;
import io.micronaut.expressions.parser.ast.operator.binary.PowOperator;
import io.micronaut.expressions.parser.ast.operator.binary.SubOperator;
import io.micronaut.expressions.parser.ast.operator.unary.EmptyOperator;
import io.micronaut.expressions.parser.ast.operator.unary.NegOperator;
import io.micronaut.expressions.parser.ast.operator.unary.NotOperator;
import io.micronaut.expressions.parser.ast.operator.unary.PosOperator;
import io.micronaut.expressions.parser.ast.types.TypeIdentifier;
import io.micronaut.expressions.parser.exception.ExpressionParsingException;
import io.micronaut.expressions.parser.token.Token;
import io.micronaut.expressions.parser.token.TokenType;
import io.micronaut.expressions.parser.token.Tokenizer;
import java.util.ArrayList;
import java.util.List;

@Internal
public final class SingleEvaluatedEvaluatedExpressionParser
implements EvaluatedExpressionParser {
    private final Tokenizer tokenizer;
    private Token lookahead;

    public SingleEvaluatedEvaluatedExpressionParser(String expression) {
        this.tokenizer = new Tokenizer(expression);
        this.lookahead = this.tokenizer.getNextToken();
    }

    @Override
    public ExpressionNode parse() throws ExpressionParsingException {
        try {
            ExpressionNode expressionNode = this.expression();
            if (this.lookahead != null) {
                throw new ExpressionParsingException("Unexpected token: " + this.lookahead.value());
            }
            return expressionNode;
        }
        catch (NullPointerException ex) {
            throw new ExpressionParsingException("Unexpected end of input");
        }
    }

    private ExpressionNode expression() {
        return this.ternaryExpression();
    }

    private ExpressionNode ternaryExpression() {
        ExpressionNode orExpression = this.orExpression();
        if (this.lookahead != null) {
            if (this.lookahead.type() == TokenType.QMARK) {
                this.eat(TokenType.QMARK);
                ExpressionNode trueExpr = this.expression();
                this.eat(TokenType.COLON);
                ExpressionNode falseExpr = this.expression();
                return new TernaryExpression(orExpression, trueExpr, falseExpr);
            }
            if (this.lookahead.type() == TokenType.ELVIS) {
                this.eat(TokenType.ELVIS);
                ExpressionNode falseExpr = this.expression();
                return new ElvisOperator(orExpression, falseExpr);
            }
        }
        return orExpression;
    }

    private ExpressionNode orExpression() {
        ExpressionNode leftNode = this.andExpression();
        while (this.lookahead != null && this.lookahead.type() == TokenType.OR) {
            this.eat(TokenType.OR);
            leftNode = new OrOperator(leftNode, this.andExpression());
        }
        return leftNode;
    }

    private ExpressionNode andExpression() {
        ExpressionNode leftNode = this.equalityExpression();
        while (this.lookahead != null && this.lookahead.type() == TokenType.AND) {
            this.eat(TokenType.AND);
            leftNode = new AndOperator(leftNode, this.equalityExpression());
        }
        return leftNode;
    }

    private ExpressionNode equalityExpression() {
        ExpressionNode leftNode = this.relationalExpression();
        while (this.lookahead != null && this.lookahead.type().isOneOf(TokenType.EQ, TokenType.NE)) {
            TokenType tokenType = this.lookahead.type();
            this.eat(tokenType);
            if (tokenType == TokenType.EQ) {
                leftNode = new EqOperator(leftNode, this.relationalExpression());
                continue;
            }
            if (tokenType != TokenType.NE) continue;
            leftNode = new NeqOperator(leftNode, this.relationalExpression());
        }
        return leftNode;
    }

    private ExpressionNode relationalExpression() {
        ExpressionNode leftNode = this.additiveExpression();
        while (this.lookahead != null && this.lookahead.type().isOneOf(TokenType.GT, TokenType.GTE, TokenType.LT, TokenType.LTE, TokenType.INSTANCEOF, TokenType.MATCHES)) {
            TokenType tokenType = this.lookahead.type();
            this.eat(this.lookahead.type());
            leftNode = switch (tokenType) {
                case TokenType.GT -> new GtOperator(leftNode, this.additiveExpression());
                case TokenType.LT -> new LtOperator(leftNode, this.additiveExpression());
                case TokenType.GTE -> new GteOperator(leftNode, this.additiveExpression());
                case TokenType.LTE -> new LteOperator(leftNode, this.additiveExpression());
                case TokenType.INSTANCEOF -> new InstanceofOperator(leftNode, this.typeIdentifier(true));
                case TokenType.MATCHES -> new MatchesOperator(leftNode, this.stringLiteral());
                default -> leftNode;
            };
        }
        return leftNode;
    }

    private ExpressionNode additiveExpression() {
        ExpressionNode leftNode = this.multiplicativeExpression();
        while (this.lookahead != null && this.lookahead.type().isOneOf(TokenType.PLUS, TokenType.MINUS)) {
            TokenType tokenType = this.lookahead.type();
            this.eat(tokenType);
            if (tokenType == TokenType.PLUS) {
                leftNode = new AddOperator(leftNode, this.multiplicativeExpression());
                continue;
            }
            if (tokenType != TokenType.MINUS) continue;
            leftNode = new SubOperator(leftNode, this.multiplicativeExpression());
        }
        return leftNode;
    }

    private ExpressionNode multiplicativeExpression() {
        ExpressionNode leftNode = this.powExpression();
        while (this.lookahead != null && this.lookahead.type().isOneOf(TokenType.MUL, TokenType.DIV, TokenType.MOD)) {
            TokenType tokenType = this.lookahead.type();
            this.eat(tokenType);
            if (tokenType == TokenType.MUL) {
                leftNode = new MulOperator(leftNode, this.powExpression());
                continue;
            }
            if (tokenType == TokenType.DIV) {
                leftNode = new DivOperator(leftNode, this.powExpression());
                continue;
            }
            if (tokenType != TokenType.MOD) continue;
            leftNode = new ModOperator(leftNode, this.powExpression());
        }
        return leftNode;
    }

    private ExpressionNode powExpression() {
        ExpressionNode leftNode = this.unaryExpression();
        while (this.lookahead != null && this.lookahead.type() == TokenType.POW) {
            this.eat(TokenType.POW);
            leftNode = new PowOperator(leftNode, this.unaryExpression());
        }
        return leftNode;
    }

    private ExpressionNode unaryExpression() {
        TokenType tokenType = this.lookahead.type();
        if (tokenType == TokenType.PLUS) {
            this.eat(TokenType.PLUS);
            return new PosOperator(this.unaryExpression());
        }
        if (tokenType == TokenType.MINUS) {
            this.eat(TokenType.MINUS);
            return new NegOperator(this.unaryExpression());
        }
        if (tokenType == TokenType.NOT) {
            this.eat(TokenType.NOT);
            return new NotOperator(this.unaryExpression());
        }
        if (tokenType == TokenType.EMPTY) {
            this.eat(TokenType.EMPTY);
            return new EmptyOperator(this.unaryExpression());
        }
        if (tokenType == TokenType.INCREMENT) {
            throw new ExpressionParsingException("Prefix increment operation is not supported");
        }
        if (tokenType == TokenType.DECREMENT) {
            throw new ExpressionParsingException("Prefix decrement operation is not supported");
        }
        return this.postfixExpression();
    }

    private ExpressionNode postfixExpression() {
        ExpressionNode leftNode = this.primaryExpression();
        while (this.lookahead != null && this.lookahead.type().isOneOf(TokenType.DOT, TokenType.SAFE_NAV, TokenType.L_SQUARE, TokenType.INCREMENT, TokenType.DECREMENT)) {
            TokenType tokenType = this.lookahead.type();
            if (tokenType == TokenType.INCREMENT) {
                throw new ExpressionParsingException("Postfix increment operation is not supported");
            }
            if (tokenType == TokenType.DECREMENT) {
                throw new ExpressionParsingException("Postfix decrement operation is not supported");
            }
            if (tokenType == TokenType.DOT) {
                this.eat(TokenType.DOT);
                leftNode = this.methodOrPropertyAccess(leftNode, false);
                continue;
            }
            if (tokenType == TokenType.SAFE_NAV) {
                this.eat(TokenType.SAFE_NAV);
                leftNode = this.methodOrPropertyAccess(leftNode, true);
                continue;
            }
            if (tokenType == TokenType.L_SQUARE) {
                leftNode = this.subscriptOperator(leftNode);
                continue;
            }
            throw new ExpressionParsingException("Unexpected token: " + this.lookahead.value());
        }
        return leftNode;
    }

    private ExpressionNode primaryExpression() {
        return switch (this.lookahead.type()) {
            case TokenType.EXPRESSION_CONTEXT_REF -> this.evaluationContextAccess(true);
            case TokenType.IDENTIFIER -> this.evaluationContextAccess(false);
            case TokenType.BEAN_CONTEXT -> this.beanContextAccess();
            case TokenType.ENVIRONMENT -> this.environmentAccess();
            case TokenType.THIS -> this.thisAccess();
            case TokenType.TYPE_IDENTIFIER -> this.typeIdentifier(true);
            case TokenType.L_PAREN -> this.parenthesizedExpression();
            case TokenType.STRING, TokenType.INT, TokenType.LONG, TokenType.DOUBLE, TokenType.FLOAT, TokenType.BOOL, TokenType.NULL -> this.literal();
            default -> throw new ExpressionParsingException("Unexpected token: " + this.lookahead.value());
        };
    }

    private ExpressionNode thisAccess() {
        this.eat(TokenType.THIS);
        return new ThisAccess();
    }

    private ExpressionNode evaluationContextAccess(boolean prefixed) {
        if (prefixed) {
            this.eat(TokenType.EXPRESSION_CONTEXT_REF);
        }
        String identifier = this.eat(TokenType.IDENTIFIER).value();
        if (this.lookahead != null && this.lookahead.type() == TokenType.L_PAREN) {
            List<ExpressionNode> methodArguments = this.methodArguments();
            return new ContextMethodCall(identifier, methodArguments);
        }
        return new ContextElementAccess(identifier);
    }

    private ExpressionNode beanContextAccess() {
        this.eat(TokenType.BEAN_CONTEXT);
        this.eat(TokenType.L_SQUARE);
        if (this.lookahead == null) {
            throw new ExpressionParsingException("Bean context access must be followed by type reference");
        }
        TypeIdentifier typeIdentifier = this.lookahead.type() == TokenType.TYPE_IDENTIFIER ? this.typeIdentifier(true) : this.typeIdentifier(false);
        this.eat(TokenType.R_SQUARE);
        return new BeanContextAccess(typeIdentifier);
    }

    private ExpressionNode environmentAccess() {
        this.eat(TokenType.ENVIRONMENT);
        this.eat(TokenType.L_SQUARE);
        ExpressionNode propertyName = this.expression();
        this.eat(TokenType.R_SQUARE);
        return new EnvironmentAccess(propertyName);
    }

    private ExpressionNode methodOrPropertyAccess(ExpressionNode callee, boolean nullSafe) {
        String identifier = this.eat(TokenType.IDENTIFIER).value();
        if (this.lookahead != null && this.lookahead.type() == TokenType.L_PAREN) {
            List<ExpressionNode> methodArguments = this.methodArguments();
            return new ElementMethodCall(callee, identifier, methodArguments, nullSafe);
        }
        return new PropertyAccess(callee, identifier, nullSafe);
    }

    private ExpressionNode subscriptOperator(ExpressionNode callee) {
        this.eat(TokenType.L_SQUARE);
        ExpressionNode indexExpression = this.expression();
        SubscriptOperator subscriptOperator = new SubscriptOperator(callee, indexExpression);
        this.eat(TokenType.R_SQUARE);
        return subscriptOperator;
    }

    private List<ExpressionNode> methodArguments() {
        this.eat(TokenType.L_PAREN);
        ArrayList<ExpressionNode> arguments = new ArrayList();
        if (this.lookahead.type() != TokenType.R_PAREN) {
            arguments = this.methodArgumentsList();
        }
        this.eat(TokenType.R_PAREN);
        return arguments;
    }

    private List<ExpressionNode> methodArgumentsList() {
        ArrayList<ExpressionNode> arguments = new ArrayList<ExpressionNode>();
        if (this.lookahead.type() != TokenType.R_PAREN) {
            ExpressionNode firstArgument = this.expression();
            arguments.add(firstArgument);
            while (this.lookahead.type() != TokenType.R_PAREN) {
                this.eat(TokenType.COMMA);
                arguments.add(this.expression());
            }
        }
        return arguments;
    }

    private TypeIdentifier typeIdentifier(boolean wrapped) {
        if (wrapped) {
            this.eat(TokenType.TYPE_IDENTIFIER);
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.eat(TokenType.IDENTIFIER).value());
        while (this.lookahead != null && this.lookahead.type() == TokenType.DOT) {
            this.eat(TokenType.DOT);
            parts.add(this.eat(TokenType.IDENTIFIER).value());
        }
        if (wrapped) {
            this.eat(TokenType.R_PAREN);
        }
        return new TypeIdentifier(String.join((CharSequence)".", parts));
    }

    private ExpressionNode parenthesizedExpression() {
        this.eat(TokenType.L_PAREN);
        ExpressionNode parenthesizedExpression = this.expression();
        this.eat(TokenType.R_PAREN);
        return parenthesizedExpression;
    }

    private ExpressionNode literal() {
        return switch (this.lookahead.type()) {
            case TokenType.DOUBLE -> this.doubleLiteral();
            case TokenType.FLOAT -> this.floatLiteral();
            case TokenType.INT -> this.intLiteral();
            case TokenType.STRING -> this.stringLiteral();
            case TokenType.LONG -> this.longLiteral();
            case TokenType.BOOL -> this.boolLiteral();
            case TokenType.NULL -> this.nullLiteral();
            default -> throw new ExpressionParsingException("Unknown literal type: " + this.lookahead.type());
        };
    }

    private StringLiteral stringLiteral() {
        Token token = this.eat(TokenType.STRING);
        String value = token.value();
        return new StringLiteral(token.value().substring(1, value.length() - 1));
    }

    private DoubleLiteral doubleLiteral() {
        Token token = this.eat(TokenType.DOUBLE);
        return new DoubleLiteral(Double.parseDouble(token.value()));
    }

    private FloatLiteral floatLiteral() {
        Token token = this.eat(TokenType.FLOAT);
        return new FloatLiteral(Float.parseFloat(token.value()));
    }

    private IntLiteral intLiteral() {
        Token token = this.eat(TokenType.INT);
        return new IntLiteral(Integer.decode(token.value()));
    }

    private LongLiteral longLiteral() {
        Token token = this.eat(TokenType.LONG);
        return new LongLiteral(Long.decode(token.value().replaceAll("([lL])", "")));
    }

    private BoolLiteral boolLiteral() {
        Token token = this.eat(TokenType.BOOL);
        return new BoolLiteral(Boolean.parseBoolean(token.value()));
    }

    private NullLiteral nullLiteral() {
        this.eat(TokenType.NULL);
        return new NullLiteral();
    }

    private Token eat(TokenType tokenType) {
        if (this.lookahead == null) {
            throw new ExpressionParsingException("Unexpected end of input. Expected: '" + tokenType + "'");
        }
        Token token = this.lookahead;
        if (token.type() != tokenType) {
            throw new ExpressionParsingException("Unexpected token: " + token.value() + ". Expected: '" + tokenType + "'");
        }
        this.lookahead = this.tokenizer.getNextToken();
        return token;
    }
}

