/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.context;

import io.micronaut.context.annotation.AnnotationExpressionContext;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.expressions.EvaluatedExpressionReference;
import io.micronaut.expressions.context.DefaultExpressionCompilationContext;
import io.micronaut.expressions.context.ExpressionCompilationContext;
import io.micronaut.expressions.context.ExpressionCompilationContextFactory;
import io.micronaut.expressions.context.ExtensibleExpressionCompilationContext;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

@Internal
public final class DefaultExpressionCompilationContextFactory
implements ExpressionCompilationContextFactory {
    private static final Collection<ClassElement> CONTEXT_TYPES = ConcurrentHashMap.newKeySet();
    private ExtensibleExpressionCompilationContext sharedContext = this.recreateContext();
    private final VisitorContext visitorContext;

    public DefaultExpressionCompilationContextFactory(VisitorContext visitorContext) {
        this.visitorContext = visitorContext;
    }

    @NotNull
    private DefaultExpressionCompilationContext recreateContext() {
        return new DefaultExpressionCompilationContext((ClassElement[])CONTEXT_TYPES.toArray(ClassElement[]::new));
    }

    @Override
    @NonNull
    public ExpressionCompilationContext buildContextForMethod(@NonNull EvaluatedExpressionReference expression, @NonNull MethodElement methodElement) {
        return this.buildForExpression(expression, null).extendWith(methodElement);
    }

    @Override
    @NonNull
    public ExpressionCompilationContext buildContext(EvaluatedExpressionReference expression, ClassElement thisElement) {
        return this.buildForExpression(expression, thisElement);
    }

    @Override
    public ExpressionCompilationContextFactory registerContextClass(ClassElement contextClass) {
        CONTEXT_TYPES.add(contextClass);
        this.sharedContext = this.recreateContext();
        return this;
    }

    private ExtensibleExpressionCompilationContext buildForExpression(EvaluatedExpressionReference expression, ClassElement thisElement) {
        String annotationName = expression.annotationName();
        String memberName = expression.annotationMember();
        ClassElement annotation = this.visitorContext.getClassElement(annotationName).orElse(null);
        ExtensibleExpressionCompilationContext evaluationContext = this.sharedContext;
        if (annotation != null) {
            evaluationContext = this.addAnnotationEvaluationContext(evaluationContext, annotation);
            evaluationContext = this.addAnnotationMemberEvaluationContext(evaluationContext, annotation, memberName);
        }
        if (thisElement != null) {
            return evaluationContext.withThis(thisElement);
        }
        return evaluationContext;
    }

    private ExtensibleExpressionCompilationContext addAnnotationEvaluationContext(ExtensibleExpressionCompilationContext currentEvaluationContext, ClassElement annotation) {
        return annotation.findAnnotation(AnnotationExpressionContext.class).flatMap(av -> av.annotationClassValue("value")).map(AnnotationClassValue::getName).flatMap(this.visitorContext::getClassElement).map(currentEvaluationContext::extendWith).orElse(currentEvaluationContext);
    }

    private ExtensibleExpressionCompilationContext addAnnotationMemberEvaluationContext(ExtensibleExpressionCompilationContext currentEvaluationContext, ClassElement annotation, String annotationMember) {
        ElementQuery<MethodElement> memberQuery = ElementQuery.ALL_METHODS.onlyDeclared().annotated(am -> am.hasAnnotation(AnnotationExpressionContext.class)).named(annotationMember);
        return annotation.getEnclosedElements(memberQuery).stream().flatMap(element -> Optional.ofNullable(element.getDeclaredAnnotation(AnnotationExpressionContext.class)).stream()).flatMap(av -> av.annotationClassValue("value").stream()).map(AnnotationClassValue::getName).flatMap(className -> this.visitorContext.getClassElement((String)className).stream()).reduce(currentEvaluationContext, ExtensibleExpressionCompilationContext::extendWith, (a, b) -> a);
    }

    @Internal
    public static void reset() {
        CONTEXT_TYPES.clear();
    }
}

