/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions;

import io.micronaut.context.expressions.AbstractEvaluatedExpression;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.expressions.ExpressionEvaluationContext;
import io.micronaut.expressions.context.ExpressionWithContext;
import io.micronaut.expressions.parser.CompoundEvaluatedEvaluatedExpressionParser;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.expressions.parser.exception.ExpressionParsingException;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class EvaluatedExpressionWriter
extends AbstractClassFileWriter {
    private static final Method EVALUATED_EXPRESSIONS_CONSTRUCTOR = new Method("<init>", EvaluatedExpressionWriter.getConstructorDescriptor(Object.class));
    private static final Type EVALUATED_EXPRESSION_TYPE = Type.getType(AbstractEvaluatedExpression.class);
    private final ExpressionWithContext expressionMetadata;
    private final VisitorContext visitorContext;
    private final Element originatingElement;

    public EvaluatedExpressionWriter(ExpressionWithContext expressionMetadata, VisitorContext visitorContext, Element originatingElement) {
        super(new Element[0]);
        this.visitorContext = visitorContext;
        this.expressionMetadata = expressionMetadata;
        this.originatingElement = originatingElement;
    }

    @Override
    public void accept(ClassWriterOutputVisitor outputVisitor) throws IOException {
        String expressionClassName = this.expressionMetadata.expressionClassName();
        try (OutputStream outputStream = outputVisitor.visitClass(expressionClassName, this.getOriginatingElements());){
            ClassWriter classWriter = this.generateClassBytes(expressionClassName);
            outputStream.write(classWriter.toByteArray());
        }
    }

    private ClassWriter generateClassBytes(String expressionClassName) {
        ClassWriter classWriter = new ClassWriter(3);
        this.startPublicClass((ClassVisitor)classWriter, EvaluatedExpressionWriter.getInternalName(expressionClassName), EVALUATED_EXPRESSION_TYPE);
        GeneratorAdapter cv = this.startConstructor((ClassVisitor)classWriter, Object.class);
        cv.loadThis();
        cv.loadArg(0);
        cv.invokeConstructor(EVALUATED_EXPRESSION_TYPE, EVALUATED_EXPRESSIONS_CONSTRUCTOR);
        cv.visitInsn(177);
        cv.visitMaxs(2, 1);
        GeneratorAdapter evaluateMethodVisitor = this.startProtectedMethod(classWriter, "doEvaluate", Object.class.getName(), ExpressionEvaluationContext.class.getName());
        ExpressionVisitorContext ctx = new ExpressionVisitorContext(this.expressionMetadata.evaluationContext(), this.visitorContext, evaluateMethodVisitor);
        Object annotationValue = this.expressionMetadata.annotationValue();
        try {
            ExpressionNode ast = new CompoundEvaluatedEvaluatedExpressionParser(annotationValue).parse();
            ast.compile(ctx);
            EvaluatedExpressionWriter.pushBoxPrimitiveIfNecessary(ast.resolveType(ctx), (MethodVisitor)evaluateMethodVisitor);
        }
        catch (ExpressionCompilationException | ExpressionParsingException ex) {
            this.failCompilation(ex, annotationValue);
        }
        evaluateMethodVisitor.visitMaxs(2, 3);
        evaluateMethodVisitor.returnValue();
        return classWriter;
    }

    private void failCompilation(Throwable ex, Object initialAnnotationValue) {
        String strRepresentation = null;
        if (initialAnnotationValue instanceof String) {
            String str;
            strRepresentation = str = (String)initialAnnotationValue;
        } else if (initialAnnotationValue instanceof String[]) {
            Object[] strArray = (String[])initialAnnotationValue;
            strRepresentation = Arrays.toString(strArray);
        }
        String message = null;
        if (ex instanceof ExpressionParsingException) {
            ExpressionParsingException parsingException = (ExpressionParsingException)ex;
            message = "Failed to parse evaluated expression [" + strRepresentation + "]. Cause: " + parsingException.getMessage();
        } else if (ex instanceof ExpressionCompilationException) {
            ExpressionCompilationException compilationException = (ExpressionCompilationException)ex;
            message = "Failed to compile evaluated expression [" + strRepresentation + "]. Cause: " + compilationException.getMessage();
        }
        this.visitorContext.fail(message, this.originatingElement);
    }
}

